/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.graph.view.looks;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import lt.monarch.graph.GraphView;
import lt.monarch.graph.view.PinView;
import lt.monarch.graph.view.looks.NodeViewBase;
import lt.monarch.graph.view.looks.SimpleRectangularPin;

public class SimpleRectangularNode
extends NodeViewBase {
    protected final SimpleRectangularPin pin;

    public PinView[] getPins() {
        return new PinView[]{this.pin};
    }

    public Point getPosition() {
        Rectangle rectangle = this.getBoundsInternal();
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public void setPosition(Point point) {
        Point point2 = this.getPosition();
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        Rectangle rectangle = this.getBounds();
        rectangle.translate(n, n2);
        this.setBounds(rectangle);
        this.pin.setBounds(rectangle);
        this.body.setBounds(rectangle);
        this.fireViewChanged();
    }

    public void layout(Graphics2D graphics2D) {
        Point point = this.getPosition();
        Dimension dimension = this.body.getPreferredSize(graphics2D);
        int n = dimension.width;
        int n2 = dimension.height;
        Rectangle rectangle = new Rectangle(point.x - n / 2, point.y - n2 / 2, n, n2);
        this.pin.layout(graphics2D);
        this.pin.setBounds(rectangle);
        this.body.setBounds(rectangle);
        this.setBounds(rectangle);
        this.invalidate();
    }

    public void paint(Graphics2D graphics2D) {
        Rectangle rectangle = this.getBoundsInternal();
        graphics2D.setColor(this.background);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics2D.setColor(this.foreground);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        this.body.paint(graphics2D);
    }

    public SimpleRectangularNode(GraphView graphView, Object object) {
        super(object);
        this.pin = new SimpleRectangularPin(this, object);
        this.addSubView(this.pin);
        graphView.pinRegistry.setViewFor(this.getModelNode(), this.pin);
    }
}

