/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.graph.plugins;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import lt.monarch.graph.AbstractGraphViewPlugin;
import lt.monarch.graph.GraphView;
import lt.monarch.graph.plugins.LinkDragStrategy;
import lt.monarch.graph.plugins.NodeSelectionManager;
import lt.monarch.graph.view.LinkConnector;
import lt.monarch.graph.view.LinkView;
import lt.monarch.graph.view.NodeView;
import lt.monarch.graph.view.PinView;
import lt.monarch.graph.view.ViewObject;
import lt.monarch.graph.view.looks.LinkPaintUtilities;
import lt.monarch.graph.view.utils.ArrowLinkConnector;
import lt.monarch.graph.view.utils.DotLinkConnector;

public class LinkDragger
extends AbstractGraphViewPlugin
implements MouseMotionListener,
MouseListener {
    private final LinkDragStrategy b;
    private int c = 1;
    private int d = 1;
    private LinkConnector e = new DotLinkConnector();
    private LinkConnector f = new ArrowLinkConnector();
    private PinView g;
    private LinkView h;
    private Point i;
    private Rectangle j;
    private Rectangle k;

    public void setInputModifierMask(int n) {
        this.c = n;
        this.d = 1;
    }

    public void setInputModifierMask(int n, int n2) {
        this.c = n;
        this.d = n2;
    }

    public void install(GraphView graphView) {
        super.install(graphView);
        graphView.addMouseListener(5, this);
        graphView.addMouseMotionListener(5, this);
    }

    public void uninstall(GraphView graphView) {
        graphView.removeMouseListener(5, this);
        graphView.removeMouseMotionListener(5, this);
        super.uninstall(graphView);
    }

    /*
     * Unable to fully structure code
     */
    protected PinView getPinAt(Point var1_1, PinView var2_2) {
        var3_3 = this.getGraphView().nodeLayer.getViewAt(var1_1);
        if (var3_3 instanceof PinView) {
            return (PinView)var3_3;
        }
        if (var3_3 instanceof NodeView) {
            var4_4 = (NodeView)var3_3;
            var5_5 = var4_4.getPins();
            var6_6 = null;
            var7_7 = 0;
            block0: while (var7_7 < var5_5.length) {
                v0 = var2_2;
                while (true) {
                    v1 = var8_8 = v0 == null ? this.b.isValidOriginPin(var5_5[var7_7].getModelPin()) : this.b.isValidTargetPin(var2_2.getModelPin(), var5_5[var7_7].getModelPin());
                    if (var8_8) {
                        if (var6_6 != null) {
                            return null;
                        }
                        var6_6 = var5_5[var7_7];
                    }
                    ++var7_7;
                    continue block0;
                    break;
                }
            }
            v0 = var6_6;
            if (NodeSelectionManager.d != 0) ** continue;
            return v0;
        }
        return null;
    }

    protected LinkView getLinkAt(Point point) {
        ViewObject viewObject = this.getGraphView().linkLayer.getViewAt(point);
        return viewObject instanceof LinkView ? (LinkView)viewObject : null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block13: {
            PinView pinView;
            Point point;
            block12: {
                this.h = null;
                this.g = null;
                if (mouseEvent.isConsumed()) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                this.i = point = mouseEvent.getPoint();
                LinkView linkView = this.getLinkAt(point);
                if (linkView == null) break block12;
                pinView = linkView.getNearestPinAt(point);
                if (linkView.getTargetPin() == pinView) {
                    this.g = linkView.getOriginPin();
                    this.h = linkView;
                }
                if (NodeSelectionManager.d == 0) break block13;
            }
            if ((mouseEvent.getModifiers() & this.c) != this.c) {
                return;
            }
            pinView = this.getPinAt(point, null);
            if (pinView != null) {
                if (!pinView.contains(point) && (mouseEvent.getModifiers() & this.d) != this.d) {
                    return;
                }
                if (pinView.contains(point)) {
                    mouseEvent.consume();
                }
                if (!this.b.isValidOriginPin(pinView.getModelPin())) {
                    return;
                }
                this.g = pinView;
            }
        }
        if (this.g != null) {
            this.j = this.k = this.a(this.i);
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.g != null) {
            Point point;
            PinView pinView;
            Rectangle rectangle = this.a(this.i);
            rectangle.add(this.k);
            this.getGraphView().repaint(rectangle);
            if (this.h == null && (pinView = this.getPinAt(point = mouseEvent.getPoint(), this.g)) != null && this.b.isValidTargetPin(this.g.getModelPin(), pinView.getModelPin())) {
                try {
                    this.b.addLink(this.g.getModelPin(), pinView.getModelPin());
                }
                catch (IllegalAccessError illegalAccessError) {
                    // empty catch block
                }
            }
            this.h = null;
            this.g = null;
            mouseEvent.consume();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private Rectangle a(Point point) {
        Point point2 = this.g.getConnectionPoint();
        Rectangle rectangle = new Rectangle(Math.min(point2.x, point.x) - 10, Math.min(point2.y, point.y) - 10, Math.abs(point2.x - point.x) + 20, Math.abs(point2.y - point.y) + 20);
        PinView pinView = this.getPinAt(point, this.g);
        if (pinView != null && this.b.isValidTargetPin(this.g.getModelPin(), pinView.getModelPin())) {
            Rectangle rectangle2 = pinView.getBounds();
            rectangle2.grow(10, 10);
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.h != null) {
            this.k.add(this.h.getBounds());
            this.getGraphView().linkLayer.removeView(this.h);
            this.b.removeLink(this.h.getOriginPin().getModelPin(), this.h.getTargetPin().getModelPin());
            this.h = null;
        }
        if (this.g != null) {
            mouseEvent.consume();
            this.i = mouseEvent.getPoint();
            this.j = this.a(this.i);
            Rectangle rectangle = new Rectangle(this.j);
            rectangle.add(this.k);
            this.getGraphView().repaint(rectangle);
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.g != null) {
            this.k = this.j;
            Point point = this.g.getConnectionPoint();
            Point point2 = this.i;
            point = this.g.getConnectionPoint(point2);
            PinView pinView = this.getPinAt(point2, this.g);
            if (pinView != null && this.b.isValidTargetPin(this.g.getModelPin(), pinView.getModelPin())) {
                graphics2D.setColor(Color.blue);
                Rectangle rectangle = pinView.getHotBounds();
                int n = Math.min(rectangle.width, rectangle.height) + 7;
                rectangle = new Rectangle(rectangle.x + rectangle.width / 2 - n / 2, rectangle.y + rectangle.height / 2 - n / 2, n, n);
                this.k.add(rectangle);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawOval(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            graphics2D.setColor(Color.black);
            LinkPaintUtilities.drawLink(graphics2D, point, point2, this.e, this.f);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public LinkDragger(LinkDragStrategy linkDragStrategy) {
        this.b = linkDragStrategy;
    }
}

