/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.util;

import java.io.Serializable;

public class JID
implements Serializable {
    private String username = null;
    private String server;
    private String resource = null;

    public JID(String string) {
        this.server = string;
        if (string == null || string.equals("")) {
            throw new RuntimeException("illegal null server value");
        }
        this.server.intern();
    }

    public JID(String string, String string2, String string3) {
        this(string2);
        this.username = string;
        this.resource = string3;
        if (string != null && string.equals("")) {
            this.username = null;
        }
        if (string != null) {
            this.username.intern();
        }
        if (string3 != null && string3.equals("")) {
            this.resource = null;
        }
        if (string3 != null) {
            this.resource.intern();
        }
    }

    public static JID fromString(String string) {
        String string2;
        String string3;
        String string4;
        int n;
        if (string.regionMatches(true, 0, "jabber:", 0, 7)) {
            string = string.substring(7);
        }
        if ((n = string.indexOf("@")) == -1) {
            string4 = null;
        } else {
            string4 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        n = string.indexOf("/");
        if (n == -1) {
            string3 = null;
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return new JID(string4, string2, string3);
    }

    public String getUsername() {
        return this.username;
    }

    public String getServer() {
        return this.server;
    }

    public String getResource() {
        return this.resource;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.username != null) {
            stringBuffer.append(this.username);
            stringBuffer.append("@");
        }
        stringBuffer.append(this.server);
        if (this.resource != null) {
            stringBuffer.append("/");
            stringBuffer.append(this.resource);
        }
        return new String(stringBuffer);
    }

    public String toPrettyString() {
        String string = this.toString();
        int n = string.indexOf(63);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public boolean equals(JID jID) {
        if (!(jID.getUsername() == this.getUsername() || jID.getUsername() != null && this.getUsername() != null && jID.getUsername().equalsIgnoreCase(this.getUsername()))) {
            return false;
        }
        if (!(jID.getResource() == this.getResource() || jID.getResource() != null && this.getResource() != null && jID.getResource().equals(this.getResource()))) {
            return false;
        }
        return jID.getServer() == this.getServer() || jID.getServer().equalsIgnoreCase(this.getServer());
    }
}

