/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.serverside;

import org.jabber.jabberbeans.ContentPacket;
import org.jabber.jabberbeans.Extension.Extension;
import org.jabber.jabberbeans.XMLData;
import org.jabber.jabberbeans.serverside.XDBBuilder;

public class XDB
extends ContentPacket {
    protected String namespace;
    protected String action;
    protected String match;

    public XDB(XDBBuilder xDBBuilder) throws InstantiationException {
        super(xDBBuilder);
        this.namespace = xDBBuilder.getNamespace();
        this.action = xDBBuilder.getAction();
        this.match = xDBBuilder.getMatch();
        if (this.extensions.size() > 1) {
            throw new InstantiationException("XDB allows up to one extension");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAction() {
        return this.action;
    }

    public String getMatch() {
        return this.match;
    }

    public void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append("<xdb");
        this.appendBaseAttribs(stringBuffer);
        XMLData.appendAttrib(stringBuffer, "error", this.getErrorText());
        XMLData.appendAttrib(stringBuffer, "ns", this.namespace);
        XMLData.appendAttrib(stringBuffer, "action", this.action);
        stringBuffer.append(">");
        this.appendExtension(stringBuffer);
        stringBuffer.append("</xdb>");
    }

    private void appendExtension(StringBuffer stringBuffer) {
        if (this.extensions.size() > 0) {
            Extension extension = (Extension)this.extensions.firstElement();
            extension.appendItem(stringBuffer);
        }
    }
}

