/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.serverside;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.Packet;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.PacketListener;
import org.jabber.jabberbeans.XMLStreamError;
import org.jabber.jabberbeans.XMLStreamHeaderBuilder;
import org.jabber.jabberbeans.serverside.Handshake;
import org.jabber.jabberbeans.serverside.ServerModule;
import org.jabber.jabberbeans.util.JID;
import org.jabber.jabberbeans.util.PacketDebug;
import org.jabber.jabberbeans.util.SHA1Helper;
import org.jabber.jabberbeans.util.SyncPacketListener;

public class Launcher {
    XMLStreamHeaderBuilder xsbuilder;
    boolean bAccept = false;
    boolean bConnect = true;
    boolean bExec = false;
    String servername = "localhost";
    int port = 4001;
    String host = "javaarchive";
    String sessionID = "a1b2c3d4e5";
    String secret = "argh!";
    String servermodule = "full.class.name";
    ConnectionBean cb;
    private static final String HANDSHAKE_TIMEOUT = "Error: timeout while waiting for server handshake";
    private static final String BASE_ACCEPT_XMLNS = "jabber:component:accept";
    private static final String BASE_EXEC_XMLNS = "jabber:component:exec";

    public static final void main(String[] stringArray) {
        new Launcher().start();
    }

    public final void start() {
        this.cb = new ConnectionBean();
        this.xsbuilder = new XMLStreamHeaderBuilder();
        if (this.bAccept) {
            System.err.println("starting accept handler");
            this.AcceptHandler();
            return;
        }
        if (this.bConnect) {
            System.err.println("starting connect handler");
            this.ConnectHandler();
            return;
        }
        if (this.bExec) {
            System.err.println("starting exec handler");
            this.ExecHandler();
            return;
        }
    }

    protected void AcceptHandler() {
        Packet packet;
        SHA1Helper sHA1Helper;
        this.cb.addPacketListener(new PacketDebug());
        SyncPacketListener syncPacketListener = new SyncPacketListener(this.cb);
        try {
            sHA1Helper = new SHA1Helper();
        }
        catch (InstantiationException instantiationException) {
            System.err.println("error in creating SHA helper class");
            return;
        }
        this.cb.disableStreamHeader();
        try {
            this.cb.connect(InetAddress.getByName(this.servername), this.port);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("error in communication for connect request");
            return;
        }
        this.xsbuilder.setXMLNS(BASE_ACCEPT_XMLNS);
        this.xsbuilder.setIdentifier(this.sessionID);
        this.xsbuilder.setFromAddress(new JID(this.host));
        this.xsbuilder.setToAddress(new JID(this.servername));
        Packet packet2 = this.xsbuilder.build();
        SyncPacketListener syncPacketListener2 = syncPacketListener;
        synchronized (syncPacketListener2) {
            System.err.println("sending header");
            this.cb.send(packet2);
            try {
                System.err.println("waiting for response");
                packet = syncPacketListener.waitForType(packet2, 5000);
                System.err.println("got response");
            }
            catch (InterruptedException interruptedException) {
                packet = null;
            }
        }
        if (packet == null) {
            throw new RuntimeException("unable to verify server on port");
        }
        System.err.println("computing handshake");
        String string = this.cb.getSessionID();
        Handshake handshake = new Handshake(sHA1Helper.digest(string, this.secret));
        packet = null;
        System.err.println("created handshake");
        syncPacketListener.reset();
        try {
            SyncPacketListener syncPacketListener3 = syncPacketListener;
            synchronized (syncPacketListener3) {
                this.cb.send(handshake);
                System.err.println("waiting for handshake response");
                packet = syncPacketListener.waitForType(handshake, 5000);
                System.err.println("got handshake?!");
            }
        }
        catch (InterruptedException interruptedException) {
            packet = null;
        }
        if (packet == null) {
            throw new RuntimeException("unable to handshake with server");
        }
        this.ServerConnect();
    }

    protected void ConnectHandler() {
        Socket socket;
        ServerSocket serverSocket;
        HandshakeValidator handshakeValidator = new HandshakeValidator();
        this.cb.addPacketListener(new PacketDebug());
        try {
            serverSocket = new ServerSocket(this.port);
            System.err.println("blocking for incoming connection");
            socket = serverSocket.accept();
            System.err.println("got incoming connection");
        }
        catch (IOException iOException) {
            System.err.println("cannot open listening port " + this.port);
            return;
        }
        try {
            this.cb.addPacketListener(handshakeValidator);
            this.cb.disableStreamHeader();
            System.err.println("merging connection");
            this.cb.connect(socket);
            System.err.println("connected!");
        }
        catch (IOException iOException) {
            System.err.println("IO error while attempting to connect to server:");
            System.err.println(iOException.toString());
            return;
        }
        this.xsbuilder.setXMLNS(BASE_ACCEPT_XMLNS);
        this.xsbuilder.setIdentifier(this.sessionID);
        this.xsbuilder.setToAddress(new JID(this.servername));
        this.xsbuilder.setFromAddress(new JID(this.host));
        Packet packet = this.xsbuilder.build();
        Launcher launcher = this;
        synchronized (launcher) {
            this.cb.send(packet);
            System.err.println("sent header");
            System.err.println("waiting");
            try {
                this.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!handshakeValidator.isValid()) {
            System.err.println("error on handshake, timeout or invalid response.");
            this.cb.send(new XMLStreamError("Timout/ Error on handshake"));
            try {
                serverSocket.close();
                this.cb.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        this.cb.send(new Handshake(null));
        this.ServerConnect();
    }

    protected void ExecHandler() {
        Packet packet;
        SyncPacketListener syncPacketListener = new SyncPacketListener(this.cb);
        try {
            this.cb.disableStreamHeader();
            this.cb.connect(System.in, System.out);
        }
        catch (IOException iOException) {
            System.err.println("IO error while attempting to connect to server:");
            System.err.println(iOException.toString());
            return;
        }
        this.xsbuilder.setXMLNS(BASE_EXEC_XMLNS);
        this.xsbuilder.setToAddress(new JID(this.servername));
        this.xsbuilder.setFromAddress(new JID(this.host));
        this.xsbuilder.setIdentifier(this.sessionID);
        Packet packet2 = this.xsbuilder.build();
        Launcher launcher = this;
        synchronized (launcher) {
            try {
                this.cb.send(packet2);
                packet = syncPacketListener.waitForType(packet2, 5000);
            }
            catch (InterruptedException interruptedException) {
                packet = null;
            }
        }
        if (packet == null) {
            System.err.println("connection timed out");
        }
        this.ServerConnect();
    }

    public void ServerConnect() {
        ServerModule serverModule;
        try {
            serverModule = (ServerModule)Class.forName(this.servermodule).newInstance();
        }
        catch (InstantiationException instantiationException) {
            System.err.println("unable to start serverside module");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("unable to find serverside module");
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("accessviolation while instantiation serverside module");
            return;
        }
        this.cb.addPacketListener(serverModule);
        System.err.println("instantiating serverside module");
        serverModule.instantiate(this.cb, this.host);
    }

    private class HandshakeValidator
    implements PacketListener {
        private String validResponse;
        private boolean bValid = false;

        public HandshakeValidator() {
            try {
                SHA1Helper sHA1Helper = new SHA1Helper();
                this.validResponse = sHA1Helper.digest(Launcher.this.sessionID, Launcher.this.secret);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException("Cannot create key value");
            }
        }

        public boolean isValid() {
            return this.bValid;
        }

        public void receivedPacket(PacketEvent packetEvent) {
            if (!(packetEvent.getPacket() instanceof Handshake)) {
                return;
            }
            if (packetEvent.getSource() != Launcher.this.cb) {
                return;
            }
            System.err.println("received our handshake!");
            Handshake handshake = (Handshake)packetEvent.getPacket();
            this.bValid = handshake.getContent().equals(this.validResponse);
            Launcher launcher = Launcher.this;
            synchronized (launcher) {
                Launcher.this.notify();
            }
        }

        public void sentPacket(PacketEvent packetEvent) {
        }

        public void sendFailed(PacketEvent packetEvent) {
        }
    }
}

