/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.sax;

import org.jabber.jabberbeans.Extension.Extension;
import org.jabber.jabberbeans.PacketBuilder;
import org.jabber.jabberbeans.sax.HandlerFactory;
import org.jabber.jabberbeans.sax.SubHandler;
import org.jabber.jabberbeans.util.JID;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public abstract class PacketSubHandler
extends SubHandler {
    protected PacketBuilder builder;
    protected StringBuffer elementChars = null;

    protected final void handleStartElement(String string, AttributeList attributeList) throws SAXException {
        if (this.packetStartElement(string, attributeList)) {
            return;
        }
        if (string.equals("error")) {
            this.builder.setErrorCode(attributeList.getValue("code"));
            this.elementChars = new StringBuffer();
            return;
        }
        HandlerFactory handlerFactory = this.getHandlerFactory();
        SubHandler subHandler = handlerFactory.getHandlerInstance(string, attributeList);
        if (subHandler != null) {
            this.setChildSubHandler(subHandler, string, attributeList);
            return;
        }
    }

    protected boolean packetStartElement(String string, AttributeList attributeList) throws SAXException {
        return false;
    }

    protected final void startHandler(String string, AttributeList attributeList) throws SAXException {
        this.builder.reset();
        this.builder.setIdentifier("none");
        this.elementChars = new StringBuffer();
        if (attributeList.getValue("to") != null) {
            this.builder.setToAddress(JID.fromString(attributeList.getValue("to")));
        }
        if (attributeList.getValue("from") != null) {
            this.builder.setFromAddress(JID.fromString(attributeList.getValue("from")));
        }
        if (attributeList.getValue("id") != null) {
            this.builder.setIdentifier(attributeList.getValue("id"));
        }
        if (attributeList.getValue("type") != null) {
            this.builder.setType(attributeList.getValue("type"));
        }
        this.packetStartHandler(string, attributeList);
    }

    protected void packetStartHandler(String string, AttributeList attributeList) {
    }

    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        this.elementChars.append(cArray, n, n2);
    }

    protected final void handleEndElement(String string) throws SAXException {
        if (string.equals("error")) {
            this.builder.setErrorText(new String(this.elementChars));
        }
        this.packetEndElement(string);
    }

    protected void packetEndElement(String string) throws SAXException {
    }

    protected final Object stopHandler(String string) throws SAXException {
        try {
            return this.builder.build();
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException("PkSH: invalid XML/invalid build:" + instantiationException.toString());
        }
    }

    protected final void receiveChildData(SubHandler subHandler, Object object) {
        this.builder.addExtension((Extension)object);
    }
}

