/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jabber.jabberbeans.Extension.Extension;
import org.jabber.jabberbeans.Extension.Roster;
import org.jabber.jabberbeans.Extension.RosterBuilder;
import org.jabber.jabberbeans.IQBean;
import org.jabber.jabberbeans.InfoQuery;
import org.jabber.jabberbeans.InfoQueryBuilder;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.PacketListener;
import org.jabber.jabberbeans.RosterItem;
import org.jabber.jabberbeans.RosterItemBuilder;
import org.jabber.jabberbeans.RosterListener;

public class RosterBean
implements Serializable {
    private IQBean connection;
    private Vector rosterListeners = new Vector();
    private Hashtable currentRoster = new Hashtable();
    private InfoQueryBuilder IQBuilder = null;
    private RosterBuilder rosterBuilder = null;
    private RosterItemBuilder rosterItemBuilder = null;
    private RosterPacketListener listener = null;

    public void setIQBean(IQBean iQBean) {
        this.connection = iQBean;
        this.listener = new RosterPacketListener();
        iQBean.addPacketListener(this.listener);
    }

    public IQBean getIQBean() {
        return this.connection;
    }

    public void refreshRoster() throws InstantiationException {
        if (this.IQBuilder == null) {
            this.IQBuilder = new InfoQueryBuilder();
        } else {
            this.IQBuilder.reset();
        }
        this.IQBuilder.setType("get");
        if (this.rosterBuilder == null) {
            this.rosterBuilder = new RosterBuilder();
        } else {
            this.rosterBuilder.reset();
        }
        this.IQBuilder.addExtension(this.rosterBuilder.build());
        this.connection.send((InfoQuery)this.IQBuilder.build());
    }

    public synchronized void addRosterItem(RosterItem rosterItem) throws InstantiationException {
        if (this.IQBuilder == null) {
            this.IQBuilder = new InfoQueryBuilder();
        } else {
            this.IQBuilder.reset();
        }
        this.IQBuilder.setType("set");
        if (this.rosterBuilder == null) {
            this.rosterBuilder = new RosterBuilder();
        } else {
            this.rosterBuilder.reset();
        }
        this.rosterBuilder.addRosterItem(rosterItem);
        this.IQBuilder.addExtension(this.rosterBuilder.build());
        this.connection.send((InfoQuery)this.IQBuilder.build());
    }

    public synchronized void delRosterItem(RosterItem rosterItem) throws InstantiationException {
        if (this.IQBuilder == null) {
            this.IQBuilder = new InfoQueryBuilder();
        } else {
            this.IQBuilder.reset();
        }
        this.IQBuilder.setType("set");
        if (this.rosterBuilder == null) {
            this.rosterBuilder = new RosterBuilder();
        } else {
            this.rosterBuilder.reset();
        }
        if (this.rosterItemBuilder == null) {
            this.rosterItemBuilder = new RosterItemBuilder();
        } else {
            this.rosterItemBuilder.reset();
        }
        this.rosterItemBuilder.copyItem(rosterItem);
        this.rosterItemBuilder.setSubscriptionType("remove");
        this.rosterBuilder.addRosterItem(this.rosterItemBuilder.build());
        this.IQBuilder.addExtension(this.rosterBuilder.build());
        this.connection.send((InfoQuery)this.IQBuilder.build());
    }

    public synchronized void addRosterListener(RosterListener rosterListener) {
        if (!this.rosterListeners.contains(rosterListener)) {
            this.rosterListeners.addElement(rosterListener);
        }
    }

    public synchronized void delRosterListener(RosterListener rosterListener) {
        this.rosterListeners.removeElement(rosterListener);
    }

    public Enumeration entries() {
        return this.currentRoster.elements();
    }

    private void fireUserRosterChanged(Roster roster) {
        Enumeration enumeration = this.rosterListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RosterListener)enumeration.nextElement()).changedRoster(roster);
        }
    }

    private void fireUserRosterReplaced(Roster roster) {
        Enumeration enumeration = this.rosterListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RosterListener)enumeration.nextElement()).replacedRoster(roster);
        }
    }

    class RosterPacketListener
    implements PacketListener {
        RosterPacketListener() {
        }

        public void receivedPacket(PacketEvent packetEvent) {
            if (!(packetEvent.getPacket() instanceof InfoQuery)) {
                return;
            }
            Enumeration enumeration = ((InfoQuery)packetEvent.getPacket()).Extensions();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return;
            }
            Extension extension = (Extension)enumeration.nextElement();
            if (!(extension instanceof Roster)) {
                return;
            }
            Roster roster = (Roster)extension;
            if (((InfoQuery)packetEvent.getPacket()).getType().equals("result")) {
                Enumeration enumeration2 = roster.items();
                RosterBean.this.currentRoster.clear();
                while (enumeration2.hasMoreElements()) {
                    RosterItem rosterItem = (RosterItem)enumeration2.nextElement();
                    RosterBean.this.currentRoster.put(rosterItem.getJID(), rosterItem);
                }
                RosterBean.this.fireUserRosterReplaced(roster);
            } else {
                Enumeration enumeration3 = roster.items();
                while (enumeration3.hasMoreElements()) {
                    RosterItem rosterItem = (RosterItem)enumeration3.nextElement();
                    RosterBean.this.currentRoster.put(rosterItem.getJID(), rosterItem);
                }
                RosterBean.this.fireUserRosterChanged(roster);
            }
        }

        public void sentPacket(PacketEvent packetEvent) {
        }

        public void sendFailed(PacketEvent packetEvent) {
        }
    }
}

