/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.Message;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.PacketListener;
import org.jabber.jabberbeans.PacketListenerRegistrar;
import org.jabber.jabberbeans.PacketRebroadcaster;

public class MessengerBean
implements Serializable,
PacketListenerRegistrar {
    private ConnectionBean connection = null;
    private PacketRebroadcaster rebroadcaster = new MessageListener();

    public MessengerBean() {
    }

    public MessengerBean(ConnectionBean connectionBean) {
        this();
        this.setConnection(connectionBean);
    }

    public void setConnection(ConnectionBean connectionBean) {
        this.connection = connectionBean;
        this.rebroadcaster.registerListener(connectionBean);
    }

    public ConnectionBean getConnection() {
        return this.connection;
    }

    public void send(Message message) {
        if (this.connection == null) {
            throw new RuntimeException("MessengerBean not connected to a ConnectionBean object");
        }
        this.connection.send(message);
    }

    public synchronized void addPacketListener(PacketListener packetListener) {
        this.rebroadcaster.addPacketListener(packetListener);
    }

    public synchronized void delPacketListener(PacketListener packetListener) {
        this.rebroadcaster.delPacketListener(packetListener);
    }

    class MessageListener
    extends PacketRebroadcaster {
        MessageListener() {
        }

        public void receivedPacket(PacketEvent packetEvent) {
            if (packetEvent.getPacket() instanceof Message && packetEvent.getSource() == MessengerBean.this.connection) {
                this.fireReceived(packetEvent);
            }
        }

        public void sentPacket(PacketEvent packetEvent) {
            if (packetEvent.getPacket() instanceof Message && packetEvent.getSource() == MessengerBean.this.connection) {
                this.fireSent(packetEvent);
            }
        }

        public void sendFailed(PacketEvent packetEvent) {
            if (packetEvent.getPacket() instanceof Message && packetEvent.getSource() == MessengerBean.this.connection) {
                this.fireSendFailed(packetEvent);
            }
        }
    }
}

