/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import org.jabber.jabberbeans.ConnectionEvent;
import org.jabber.jabberbeans.ConnectionListener;
import org.jabber.jabberbeans.Packet;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.PacketListener;
import org.jabber.jabberbeans.PacketListenerRegistrar;
import org.jabber.jabberbeans.XMLStreamHeader;
import org.jabber.jabberbeans.XMLStreamHeaderBuilder;
import org.jabber.jabberbeans.sax.InputStreamHandler;
import org.jabber.jabberbeans.sax.OutputStreamHandler;
import org.jabber.jabberbeans.util.JID;

public class ConnectionBean
implements Serializable,
PacketListenerRegistrar {
    private ConnectionEvent.EState status;
    private final Vector connectionListeners = new Vector();
    private final Vector packetListeners = new Vector();
    private Socket socket = null;
    private InputStreamHandler input = null;
    private OutputStreamHandler output = null;
    public static final int DEFAULT_PORT = 5222;
    private static final String DEFAULT_XMLSTREAM_NS = "jabber:client";
    private String sessionID = null;
    private boolean DisableAutoHeader = false;

    public ConnectionBean() {
        this.status = ConnectionEvent.STATE_DISCONNECTED;
        this.output = new OutputStreamHandler(new OutputStreamInterface());
        this.input = new InputStreamHandler(new InputStreamInterface());
        this.addPacketListener(new XMLStreamMonitor());
    }

    public void setParser(String string) {
        this.input.setParser(string);
    }

    public String getParser() {
        return this.input.getParser();
    }

    public void connect(InetAddress inetAddress) throws IOException {
        this.connect(inetAddress, inetAddress.getHostName(), 5222);
    }

    public void connect(InetAddress inetAddress, String string) throws IOException {
        this.setConnecting();
        this.connect(inetAddress, string, 5222);
    }

    public synchronized void connect(InetAddress inetAddress, int n) throws IOException {
        this.setConnecting();
        this.connect(inetAddress, inetAddress.getHostName(), n);
    }

    public synchronized void connect(InetAddress inetAddress, String string, int n) throws IOException {
        this.setConnecting();
        Socket socket = new Socket(inetAddress, n);
        this.connect(socket);
        if (!this.DisableAutoHeader) {
            XMLStreamHeaderBuilder xMLStreamHeaderBuilder = new XMLStreamHeaderBuilder();
            xMLStreamHeaderBuilder.setToAddress(new JID(inetAddress.getHostName()));
            xMLStreamHeaderBuilder.setXMLNS(DEFAULT_XMLSTREAM_NS);
            this.send(xMLStreamHeaderBuilder.build());
        }
    }

    public synchronized void connect(Socket socket) throws IOException {
        if (this.socket != null) {
            this.disconnect();
        }
        this.setConnecting();
        this.setSocket(socket);
        this.connect(socket.getInputStream(), socket.getOutputStream());
    }

    public synchronized void connect(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.setConnecting();
        this.output.setOutputStream(outputStream);
        this.output.start();
        this.input.setInputStream(inputStream);
        this.input.start();
    }

    private void setConnecting() {
        if (this.status == ConnectionEvent.STATE_DISCONNECTED) {
            this.setConnectionState(ConnectionEvent.STATE_CONNECTING, ConnectionEvent.REASON_CLIENT_INITIATED);
        }
    }

    private synchronized void setSocket(Socket socket) {
        this.socket = socket;
    }

    public synchronized void disconnect() {
        this.disconnected(ConnectionEvent.REASON_CLIENT_INITIATED);
    }

    private synchronized void disconnected(ConnectionEvent.EReason eReason) {
        if (this.socket != null) {
            try {
                this.input.shutdown();
                this.output.shutdown();
                this.socket.close();
                try {
                    this.input.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        this.sessionID = null;
        this.setConnectionState(ConnectionEvent.STATE_DISCONNECTED, eReason);
    }

    public final synchronized void addConnectionListener(ConnectionListener connectionListener) {
        if (!this.connectionListeners.contains(connectionListener)) {
            this.connectionListeners.addElement(connectionListener);
        }
    }

    public final synchronized void delConnectionListener(ConnectionListener connectionListener) {
        if (this.packetListeners.contains(connectionListener)) {
            this.connectionListeners.removeElement(connectionListener);
        }
    }

    public final synchronized void addPacketListener(PacketListener packetListener) {
        if (!this.packetListeners.contains(packetListener)) {
            this.packetListeners.addElement(packetListener);
        }
    }

    public final synchronized void delPacketListener(PacketListener packetListener) {
        if (this.packetListeners.contains(packetListener)) {
            this.packetListeners.removeElement(packetListener);
        }
    }

    public void send(Packet packet) {
        this.output.send(packet);
    }

    public void received(Packet packet) {
        this.fireReceivedPacket(packet);
    }

    private void sent(Packet packet) {
        this.fireSentPacket(packet);
    }

    private void sendFailed(Packet packet) {
        this.fireUnsentPacket(packet);
    }

    protected final void fireReceivedPacket(Packet packet) {
        PacketEvent packetEvent = new PacketEvent(this, packet);
        Vector vector = (Vector)this.packetListeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((PacketListener)enumeration.nextElement()).receivedPacket(packetEvent);
        }
    }

    protected final void fireSentPacket(Packet packet) {
        PacketEvent packetEvent = new PacketEvent(this, packet);
        Vector vector = (Vector)this.packetListeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((PacketListener)enumeration.nextElement()).sentPacket(packetEvent);
        }
    }

    protected final void fireUnsentPacket(Packet packet) {
        PacketEvent packetEvent = new PacketEvent(this, packet);
        Vector vector = (Vector)this.packetListeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((PacketListener)enumeration.nextElement()).sendFailed(packetEvent);
        }
    }

    public void onOutputDeath(Exception exception) {
        this.disconnected(ConnectionEvent.REASON_IO_ERROR);
    }

    public void onInputDeath(Exception exception) {
        this.disconnected(ConnectionEvent.REASON_IO_ERROR);
    }

    public final ConnectionEvent.EState getConnectionState() {
        return this.status;
    }

    protected final void setConnectionState(ConnectionEvent.EState eState, ConnectionEvent.EReason eReason) {
        ConnectionEvent connectionEvent = new ConnectionEvent(this, eState, this.getConnectionState(), eReason);
        this.status = eState;
        Vector vector = (Vector)this.connectionListeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ConnectionListener)enumeration.nextElement()).connectionChanged(connectionEvent);
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void disableStreamHeader() {
        this.DisableAutoHeader = true;
    }

    public class InputStreamInterface {
        public void received(Packet packet) {
            ConnectionBean.this.received(packet);
        }

        public void unexpectedThreadDeath(Exception exception) {
            ConnectionBean.this.onInputDeath(exception);
        }
    }

    public class OutputStreamInterface {
        public void sent(Packet packet) {
            ConnectionBean.this.sent(packet);
        }

        public void sendFailed(Packet packet) {
            ConnectionBean.this.sendFailed(packet);
        }

        public void unexpectedThreadDeath(Exception exception) {
            ConnectionBean.this.onOutputDeath(exception);
        }
    }

    public class XMLStreamMonitor
    implements PacketListener {
        public void sentPacket(PacketEvent packetEvent) {
        }

        public void receivedPacket(PacketEvent packetEvent) {
            if (!(packetEvent.getPacket() instanceof XMLStreamHeader)) {
                return;
            }
            XMLStreamHeader xMLStreamHeader = (XMLStreamHeader)packetEvent.getPacket();
            ConnectionBean.this.sessionID = xMLStreamHeader.getIdentifier();
            ConnectionBean.this.setConnectionState(ConnectionEvent.STATE_CONNECTED, ConnectionEvent.REASON_CLIENT_INITIATED);
        }

        public void sendFailed(PacketEvent packetEvent) {
        }
    }
}

