/*
 * Decompiled with CFR 0.152.
 */
package com.globalinfotek.coabsgrid.wrapping;

import com.globalinfotek.coabsgrid.wrapping.AgentOrServiceWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorUtils;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardState;
import com.globalinfotek.coabsgrid.wrapping.MultiLineLabelUI;
import com.globalinfotek.coabsgrid.wrapping.WizardPanel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class WellKnownInterfaceNameWizardPanel
extends GeneratorWizardPanel {
    private String classpath;
    private boolean inputClassIsInterface;
    private String inputClassName;
    private String implementationClassName;
    private Method[] methods;
    private JPanel mainLabelPanel;
    private JLabel mainLabel;
    private JPanel namePanel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel onlyInterfacePanel;
    private JCheckBox onlyInterfaceCheckBox;
    private WizardPanel nextPanel = null;
    private String initialWellKnownInterfaceName;
    private boolean initiallyOnlyInterface;
    private boolean initiallyFinishable;

    public WellKnownInterfaceNameWizardPanel(GeneratorWizardState generatorWizardState, String string, boolean bl, String string2, String string3, Method[] methodArray) {
        super(generatorWizardState);
        this.classpath = string;
        this.inputClassIsInterface = bl;
        this.inputClassName = string2;
        this.implementationClassName = string3;
        this.methods = methodArray;
        this.mainLabelPanel = new JPanel();
        this.mainLabel = new JLabel();
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.onlyInterfacePanel = new JPanel();
        this.onlyInterfaceCheckBox = new JCheckBox();
        String string4 = "Please enter the name that you would like to use for the well-known interface for this agent\nor service.  The well-known interface is the interface that is commonly used to look up the\nagent or service in the Jini Lookup Service.    The class name should include the fully\nspecified package name in dotted notation (e.g. com.acme.product.Widget).  Include the\npackage name and the class name, but do not include the file name extension \".class\" at\nthe end of the name.\n\nIf you would like to only generate the well-known interface, as opposed to generating all of\nthe necessary files, please check the box below.  This is normally not the case.";
        this.mainLabel.setText(string4);
        this.mainLabel.setForeground(Color.black);
        this.mainLabel.setUI(new MultiLineLabelUI());
        this.mainLabelPanel.add(this.mainLabel);
        this.add(this.mainLabelPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(new JSeparator());
        this.add(Box.createVerticalStrut(10));
        this.namePanel.setLayout(new FlowLayout(0));
        this.nameLabel.setText("Well-known interface name:");
        this.nameLabel.setForeground(Color.black);
        this.nameLabel.setLabelFor(this.nameTextField);
        this.namePanel.add(this.nameLabel);
        this.nameTextField.setColumns(30);
        this.nameTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                WellKnownInterfaceNameWizardPanel.this.nameTextFieldKeyTyped(keyEvent);
            }
        });
        this.namePanel.add(this.nameTextField);
        this.add(this.namePanel);
        this.onlyInterfacePanel.setLayout(new FlowLayout(0));
        this.onlyInterfaceCheckBox.setText("Generate well-known interface only:");
        this.onlyInterfaceCheckBox.setHorizontalTextPosition(10);
        this.onlyInterfaceCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                WellKnownInterfaceNameWizardPanel.this.onlyInterfaceCheckBoxItemStateChanged(itemEvent);
            }
        });
        this.onlyInterfacePanel.add(this.onlyInterfaceCheckBox);
        this.add(this.onlyInterfacePanel);
    }

    private void nameTextFieldKeyTyped(KeyEvent keyEvent) {
        String string = GeneratorUtils.getNewTextFieldText(keyEvent.getKeyChar(), this.nameTextField);
        int n = string.length();
        if (n == 0) {
            this.wizardState.setNextButtonEnabled(false);
            this.wizardState.setFinishButtonEnabled(false);
        } else {
            this.wizardState.setNextButtonEnabled(true);
            if (this.initialWellKnownInterfaceName.equals(string) && this.initiallyOnlyInterface == this.onlyInterfaceCheckBox.isSelected()) {
                if (this.initiallyFinishable) {
                    this.wizardState.setFinishButtonEnabled(true);
                }
            } else {
                this.wizardState.setFinishButtonEnabled(false);
            }
        }
    }

    public void onlyInterfaceCheckBoxItemStateChanged(ItemEvent itemEvent) {
        if (this.initialWellKnownInterfaceName.equals(this.nameTextField.getText())) {
            if (itemEvent.getStateChange() == 1 && this.initiallyOnlyInterface) {
                if (this.initiallyFinishable) {
                    this.wizardState.setFinishButtonEnabled(true);
                }
            } else if (itemEvent.getStateChange() == 2 && !this.initiallyOnlyInterface) {
                if (this.initiallyFinishable) {
                    this.wizardState.setFinishButtonEnabled(true);
                }
            } else {
                this.wizardState.setFinishButtonEnabled(false);
            }
        }
    }

    public WizardPanel getNextPanel() {
        if (this.nextPanel == null || !this.initialWellKnownInterfaceName.equals(this.nameTextField.getText()) || this.initiallyOnlyInterface != this.onlyInterfaceCheckBox.isSelected()) {
            this.nextPanel = new AgentOrServiceWizardPanel(this.getGeneratorWizardState(), this.classpath, this.inputClassIsInterface, this.inputClassName, this.implementationClassName, this.nameTextField.getText(), this.onlyInterfaceCheckBox.isSelected(), this.methods);
        }
        return this.nextPanel;
    }

    public void prepareToBeDisplayed() {
        if (this.nameTextField.getText().equals("")) {
            this.wizardState.setNextButtonEnabled(false);
        } else {
            this.wizardState.setNextButtonEnabled(true);
        }
        this.initialWellKnownInterfaceName = this.nameTextField.getText();
        this.initiallyOnlyInterface = this.onlyInterfaceCheckBox.isSelected();
        this.initiallyFinishable = this.wizardState.isFinishButtonEnabled();
    }

    public boolean isValid() {
        return GeneratorUtils.isValidPackagedClassName(this.nameTextField.getText());
    }

    public void showErrors() {
        if (!GeneratorUtils.isValidPackagedClassName(this.nameTextField.getText())) {
            JOptionPane.showMessageDialog(this, this.nameTextField.getText() + " is not a valid Java packaged class name.", "ERROR", 0);
        }
    }

    public void acceptValues() {
    }
}

