/*
 * Decompiled with CFR 0.152.
 */
package com.globalinfotek.coabsgrid.wrapping;

import com.globalinfotek.coabsgrid.wrapping.GenerateAntScripts1WizardPanel;
import com.globalinfotek.coabsgrid.wrapping.Generator;
import com.globalinfotek.coabsgrid.wrapping.GeneratorUtils;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardState;
import com.globalinfotek.coabsgrid.wrapping.MultiLineLabelUI;
import com.globalinfotek.coabsgrid.wrapping.WizardPanel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class JavaDirectoryWizardPanel
extends GeneratorWizardPanel {
    private String classpath;
    private boolean inputClassIsInterface;
    private boolean inputClassIsWellKnownInterface;
    private boolean generateAgent;
    private String inputClassName;
    private String implementationClassName;
    private String wellKnownInterfaceName;
    private boolean onlyInterface;
    private Method[] methods;
    private String packageName;
    private JPanel mainLabelPanel;
    private JLabel mainLabel;
    private JPanel pathPanel;
    private JLabel pathLabel;
    private JTextField pathTextField;
    private JButton pathBrowseButton;
    private JPanel overwritePanel;
    private JCheckBox overwriteCheckBox;
    private WizardPanel nextPanel = null;
    private String initialJavaDirectoryName;
    private boolean initialOverwrite;
    private boolean initiallyFinishable;

    public JavaDirectoryWizardPanel(GeneratorWizardState generatorWizardState, String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, String string4, boolean bl4, Method[] methodArray, String string5) {
        super(generatorWizardState);
        this.classpath = string;
        this.inputClassIsInterface = bl;
        this.inputClassIsWellKnownInterface = bl2;
        this.generateAgent = bl3;
        this.inputClassName = string2;
        this.implementationClassName = string3;
        this.wellKnownInterfaceName = string4;
        this.onlyInterface = bl4;
        this.methods = methodArray;
        this.packageName = string5;
        this.mainLabelPanel = new JPanel();
        this.mainLabel = new JLabel();
        this.pathPanel = new JPanel();
        this.pathLabel = new JLabel();
        this.pathTextField = new JTextField();
        this.pathBrowseButton = new JButton();
        this.overwritePanel = new JPanel();
        this.overwriteCheckBox = new JCheckBox();
        String string6 = GeneratorUtils.getClassNameFromPackagedClassName(string4);
        String string7 = string5.equals("") ? "" : string5 + ".";
        String string8 = "The following Java classes will be generated:\n\n";
        if (!bl2) {
            string8 = string8 + "    " + string4 + "\n";
        }
        if (!bl4) {
            string8 = string8 + "    " + string7 + string6 + "RemoteInterface\n";
            string8 = bl3 ? string8 + "    " + string7 + string6 + "Agent\n" + "    " + string7 + string6 + "AgentHelper\n" + "    " + string7 + string6 + "AgentRep\n" : string8 + "    " + string7 + string6 + "Service\n" + "    " + string7 + string6 + "ServiceHelper\n" + "    " + string7 + string6 + "ServiceRep\n";
        }
        String string9 = GeneratorUtils.getPackageNameFromPackagedClassName(string4);
        string8 = string8 + "\nIn which directory would you like to place the generated Java source files?\n\nThe directory which you specify will be the root of the directory hierarchy matching the package\nheirarchy of the Java classes.  If any of the relevant directories do not exist, they will be\ncreated.\n\nIf you enter a relative directory (i.e. one that does not begin with a file system root directory), the\ndirectory will be relative to the directory from which this application was started.\n\nBy default, if a file to be generated already exists, it will not be overwritten.  If you would prefer to\noverwrite existing files, please check the box below.  Regardless, a message will be displayed if\na file to be generated already exists.";
        this.mainLabel.setText(string8);
        this.mainLabel.setForeground(Color.black);
        this.mainLabel.setUI(new MultiLineLabelUI());
        this.mainLabelPanel.add(this.mainLabel);
        this.add(this.mainLabelPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(new JSeparator());
        this.add(Box.createVerticalStrut(10));
        this.pathPanel.setLayout(new FlowLayout(0));
        this.pathLabel.setText("Directory for generated\nJava source files:");
        this.pathLabel.setLabelFor(this.pathTextField);
        this.pathLabel.setForeground(Color.black);
        this.pathLabel.setUI(new MultiLineLabelUI());
        this.pathPanel.add(this.pathLabel);
        this.pathTextField.setColumns(30);
        this.pathTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                JavaDirectoryWizardPanel.this.pathTextFieldKeyTyped(keyEvent);
            }
        });
        this.pathPanel.add(this.pathTextField);
        this.pathBrowseButton.setForeground(Color.black);
        this.pathBrowseButton.setText("Browse . . .");
        this.pathBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaDirectoryWizardPanel.this.browseButtonActionPerformed(actionEvent, JavaDirectoryWizardPanel.this.pathTextField);
            }
        });
        this.pathPanel.add(this.pathBrowseButton);
        this.add(this.pathPanel);
        this.overwritePanel.setLayout(new FlowLayout(0));
        this.overwriteCheckBox.setForeground(Color.black);
        this.overwriteCheckBox.setText("Overwrite existing files:");
        this.overwriteCheckBox.setHorizontalTextPosition(10);
        this.overwritePanel.add(this.overwriteCheckBox);
        this.add(this.overwritePanel);
    }

    private void pathTextFieldKeyTyped(KeyEvent keyEvent) {
        String string = GeneratorUtils.getNewTextFieldText(keyEvent.getKeyChar(), this.pathTextField);
        int n = string.length();
        if (n == 0) {
            this.wizardState.setNextButtonEnabled(false);
            this.wizardState.setFinishButtonEnabled(false);
        } else {
            this.wizardState.setNextButtonEnabled(true);
            this.wizardState.setFinishButtonEnabled(true);
        }
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent, JTextField jTextField) {
        String string = jTextField.getText();
        if (string.equals("")) {
            string = this.getGeneratorWizardState().getDefaultPath();
        }
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, "Select Directory");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.getGeneratorWizardState().setDefaultPath(file.getParent());
            jTextField.setText(file.getAbsolutePath());
            this.wizardState.setNextButtonEnabled(true);
            this.wizardState.setFinishButtonEnabled(true);
        }
    }

    public WizardPanel getNextPanel() {
        if (this.nextPanel == null || !this.initialJavaDirectoryName.equals(this.pathTextField.getText()) || this.initialOverwrite != this.overwriteCheckBox.isSelected()) {
            this.nextPanel = new GenerateAntScripts1WizardPanel(this.getGeneratorWizardState());
        }
        this.wizardState.setFinishButtonEnabled(false);
        return this.nextPanel;
    }

    public void prepareToBeDisplayed() {
        if (this.pathTextField.getText().equals("")) {
            this.wizardState.setNextButtonEnabled(false);
            this.wizardState.setFinishButtonEnabled(false);
        } else {
            this.wizardState.setNextButtonEnabled(true);
            this.wizardState.setFinishButtonEnabled(true);
        }
        this.initialJavaDirectoryName = this.pathTextField.getText();
        this.initialOverwrite = this.overwriteCheckBox.isSelected();
        this.initiallyFinishable = this.wizardState.isFinishButtonEnabled();
    }

    public boolean isValid() {
        String string = this.pathTextField.getText();
        if (string.equals("")) {
            return false;
        }
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            this.wizardState.setFinishButtonEnabled(false);
            return false;
        }
        int n = JOptionPane.showConfirmDialog(this, "Directory " + string + " does not exist.\n" + "Do you want to create it?", "DIRECTORY DOES NOT EXIST", 0);
        if (n == 0) {
            try {
                if (file.mkdirs()) {
                    return true;
                }
                JOptionPane.showMessageDialog(this, "Could not create directory " + string + ".", "ERROR", 0);
                this.wizardState.setFinishButtonEnabled(false);
                return false;
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(this, "Could not create directory " + string + ".", "ERROR", 0);
                this.wizardState.setFinishButtonEnabled(false);
                return false;
            }
        }
        this.wizardState.setFinishButtonEnabled(false);
        return false;
    }

    public void showErrors() {
        String string = this.pathTextField.getText();
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                JOptionPane.showMessageDialog(this, string + "is not a directory.", "ERROR", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, string + "does not exist.", "ERROR", 0);
        }
    }

    public void acceptValues() {
        Generator generator = new Generator(this.classpath, this.inputClassIsInterface, this.inputClassIsWellKnownInterface, this.generateAgent, this.inputClassName, this.implementationClassName, this.wellKnownInterfaceName, this.onlyInterface, this.methods, this.packageName, this.pathTextField.getText(), this.overwriteCheckBox.isSelected());
        this.getGeneratorWizardState().setGenerator(generator);
    }
}

