/*
 * Decompiled with CFR 0.152.
 */
package com.globalinfotek.coabsgrid.wrapping;

import com.globalinfotek.coabsgrid.wrapping.FileExistsException;
import com.globalinfotek.coabsgrid.wrapping.GeneratorUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class Generator {
    private String classpath;
    private boolean inputClassIsInterface;
    private boolean inputClassIsWellKnownInterface;
    private boolean generateAgent;
    private String inputClassName;
    private String inputClassPackageName;
    private String implementationClassName;
    private String implementationClassPackageName;
    private String wellKnownInterfaceName;
    private String wellKnownInterfacePackageName;
    private String wellKnownInterfacePackagePath;
    private boolean onlyInterface;
    private Method[] methods;
    private String packageName;
    private String sourcePath;
    private String packagePath;
    private boolean overwrite;
    private boolean genAnt = false;
    private String antPath;
    private String compiledPath;
    private String commandLineArguments;
    private Vector dependencyClassNames = new Vector();
    private boolean genClient = false;
    private String clientPackageName;
    private String clientSourcePath;
    private String clientPackagePath;
    private boolean genClientAnt = false;
    private String clientAntPath;
    private String compiledClientPath;
    private String clientCommandLineArguments;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$globalinfotek$coabsgrid$ServiceRep;
    static /* synthetic */ Class class$com$globalinfotek$coabsgrid$AgentRep;

    public Generator(String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, String string4, boolean bl4, Method[] methodArray, String string5, String string6, boolean bl5) {
        if (File.separatorChar != '/') {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == File.separatorChar) {
                    stringBuffer.setCharAt(n, '/');
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        this.classpath = string;
        this.inputClassIsInterface = bl;
        this.inputClassIsWellKnownInterface = bl2;
        this.generateAgent = bl3;
        this.inputClassName = GeneratorUtils.getClassNameFromPackagedClassName(string2);
        this.inputClassPackageName = GeneratorUtils.getPackageNameFromPackagedClassName(string2);
        this.implementationClassName = GeneratorUtils.getClassNameFromPackagedClassName(string3);
        this.implementationClassPackageName = GeneratorUtils.getPackageNameFromPackagedClassName(string3);
        this.wellKnownInterfaceName = GeneratorUtils.getClassNameFromPackagedClassName(string4);
        this.wellKnownInterfacePackageName = GeneratorUtils.getPackageNameFromPackagedClassName(string4);
        this.onlyInterface = bl4;
        this.methods = methodArray;
        this.packageName = string5;
        this.sourcePath = string6;
        this.overwrite = bl5;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public boolean getGenerateAgent() {
        return this.generateAgent;
    }

    public String getWellKnownInterfaceName() {
        return this.wellKnownInterfaceName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getClientSourcePath() {
        return this.clientSourcePath;
    }

    public void setGenerateAntScripts(boolean bl) {
        this.genAnt = bl;
    }

    public boolean getGenerateAntScripts() {
        return this.genAnt;
    }

    public void setAntPath(String string) {
        this.antPath = string;
    }

    public void setCompiledPath(String string) {
        if (File.separatorChar != '/') {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == File.separatorChar) {
                    stringBuffer.setCharAt(n, '/');
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        this.compiledPath = string;
    }

    public void setCommandLineArguments(String string) {
        this.commandLineArguments = string;
    }

    public void setGenerateClient(boolean bl) {
        this.genClient = bl;
    }

    public void setClientPackageName(String string) {
        this.clientPackageName = string;
    }

    public void setClientSourcePath(String string) {
        this.clientSourcePath = string;
    }

    public void setGenerateClientAntScripts(boolean bl) {
        this.genClientAnt = bl;
    }

    public void setClientAntPath(String string) {
        this.clientAntPath = string;
    }

    public void setCompiledClientPath(String string) {
        if (File.separatorChar != '/') {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == File.separatorChar) {
                    stringBuffer.setCharAt(n, '/');
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        this.compiledClientPath = string;
    }

    public void setClientCommandLineArguments(String string) {
        this.clientCommandLineArguments = string;
    }

    public void setDependencyClassNames(Vector vector) {
        this.dependencyClassNames = vector;
    }

    public void generate() throws IOException {
        this.createDirectories();
        if (!this.inputClassIsWellKnownInterface) {
            this.generateWellKnownInterface();
        }
        if (!this.onlyInterface) {
            this.generateRemoteInterface();
            this.generateMain();
            this.generateHelper();
            this.generateRep();
        }
        if (this.genAnt) {
            this.generateAntScript();
        }
        if (this.genClient) {
            this.generateTestClient();
        }
        if (this.genClientAnt) {
            this.generateTestClientAntScript();
        }
    }

    private void createDirectories() {
        int n;
        StringBuffer stringBuffer;
        if (this.packageName.equals("")) {
            this.packagePath = this.sourcePath;
        } else {
            stringBuffer = new StringBuffer(this.packageName);
            n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '.') {
                    stringBuffer.setCharAt(n, File.separatorChar);
                }
                ++n;
            }
            this.packagePath = this.sourcePath + File.separator + stringBuffer.toString();
        }
        new File(this.packagePath).mkdirs();
        if (!this.inputClassIsWellKnownInterface) {
            if (this.wellKnownInterfacePackageName.equals("")) {
                this.wellKnownInterfacePackagePath = this.sourcePath;
            } else {
                stringBuffer = new StringBuffer(this.wellKnownInterfacePackageName);
                n = 0;
                while (n < stringBuffer.length()) {
                    if (stringBuffer.charAt(n) == '.') {
                        stringBuffer.setCharAt(n, File.separatorChar);
                    }
                    ++n;
                }
                this.wellKnownInterfacePackagePath = this.sourcePath + File.separator + stringBuffer.toString();
                new File(this.wellKnownInterfacePackagePath).mkdirs();
            }
        }
        if (this.genAnt) {
            new File(this.antPath).mkdirs();
        }
        if (this.genClient) {
            if (this.clientPackageName.equals("")) {
                this.clientPackagePath = this.clientSourcePath;
            } else {
                stringBuffer = new StringBuffer(this.clientPackageName);
                n = 0;
                while (n < stringBuffer.length()) {
                    if (stringBuffer.charAt(n) == '.') {
                        stringBuffer.setCharAt(n, File.separatorChar);
                    }
                    ++n;
                }
                this.clientPackagePath = this.clientSourcePath + File.separator + stringBuffer.toString();
            }
            new File(this.clientPackagePath).mkdirs();
        }
        if (this.genClientAnt) {
            new File(this.clientAntPath).mkdirs();
        }
    }

    private boolean throwsRemoteException(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n] == (class$java$rmi$RemoteException == null ? Generator.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private PrintWriter openOutputFile(String string, String string2) throws IOException, FileExistsException {
        Object object;
        File file = string == null ? new File(string2) : new File(string, string2);
        if (file.exists()) {
            object = file.getAbsolutePath();
            if (!this.overwrite) {
                System.out.println("WARNING: file " + (String)object + " exists - did not overwrite");
                throw new FileExistsException();
            }
            System.out.println("WARNING: overwrote file " + (String)object);
        }
        object = new PrintWriter(new FileWriter(file));
        return object;
    }

    private void generateMethodHeader(PrintWriter printWriter, Method method) {
        printWriter.print("  public ");
        printWriter.print(GeneratorUtils.getType(method.getReturnType()));
        printWriter.print(" " + method.getName() + "(");
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length > 0) {
            printWriter.print(GeneratorUtils.getType(classArray[0]) + " arg0");
            int n = 1;
            while (n < classArray.length) {
                printWriter.print(", " + GeneratorUtils.getType(classArray[n]) + " arg" + n);
                ++n;
            }
        }
        printWriter.print(")");
        Class<?>[] classArray2 = method.getExceptionTypes();
        boolean bl = false;
        if (classArray2.length > 0) {
            printWriter.print(" throws " + GeneratorUtils.getType(classArray2[0]));
            if (classArray2[0] == (class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = Generator.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException)) {
                bl = true;
            }
            int n = 1;
            while (n < classArray2.length) {
                printWriter.print(", " + GeneratorUtils.getType(classArray2[n]));
                if (classArray2[0] == (class$java$rmi$RemoteException == null ? Generator.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException)) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                printWriter.print(", java.rmi.RemoteException");
            }
        } else {
            printWriter.print(" throws java.rmi.RemoteException");
        }
    }

    private void generateWellKnownInterface() throws IOException {
        PrintWriter printWriter;
        try {
            printWriter = this.openOutputFile(this.wellKnownInterfacePackagePath, this.wellKnownInterfaceName + ".java");
        }
        catch (FileExistsException fileExistsException) {
            return;
        }
        printWriter.println("/* Generated " + new Date() + " */");
        if (!this.wellKnownInterfacePackageName.equals("")) {
            printWriter.println("package " + this.wellKnownInterfacePackageName + ";");
        }
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("import com.globalinfotek.coabsgrid.AgentRep;");
        } else {
            printWriter.println("import com.globalinfotek.coabsgrid.ServiceRep;");
        }
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("public interface " + this.wellKnownInterfaceName + " extends AgentRep {");
        } else {
            printWriter.println("public interface " + this.wellKnownInterfaceName + " extends ServiceRep {");
        }
        int n = 0;
        while (n < this.methods.length) {
            Method method = this.methods[n];
            Class<?> clazz = method.getDeclaringClass();
            boolean bl = this.generateAgent ? clazz != (class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object) && clazz != (class$com$globalinfotek$coabsgrid$ServiceRep == null ? Generator.class$("com.globalinfotek.coabsgrid.ServiceRep") : class$com$globalinfotek$coabsgrid$ServiceRep) && clazz != (class$com$globalinfotek$coabsgrid$AgentRep == null ? Generator.class$("com.globalinfotek.coabsgrid.AgentRep") : class$com$globalinfotek$coabsgrid$AgentRep) : clazz != (class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object) && clazz != (class$com$globalinfotek$coabsgrid$ServiceRep == null ? Generator.class$("com.globalinfotek.coabsgrid.ServiceRep") : class$com$globalinfotek$coabsgrid$ServiceRep);
            if (bl) {
                this.generateMethodHeader(printWriter, method);
                printWriter.println(";");
            }
            ++n;
        }
        printWriter.println("}");
        printWriter.close();
    }

    private void generateRemoteInterface() throws IOException {
        PrintWriter printWriter;
        try {
            printWriter = this.openOutputFile(this.packagePath, this.wellKnownInterfaceName + "RemoteInterface.java");
        }
        catch (FileExistsException fileExistsException) {
            return;
        }
        printWriter.println("/* Generated " + new Date() + " */");
        if (!this.packageName.equals("")) {
            printWriter.println("package " + this.packageName + ";");
        }
        printWriter.println();
        printWriter.println("public interface " + this.wellKnownInterfaceName + "RemoteInterface extends java.rmi.Remote {");
        int n = 0;
        while (n < this.methods.length) {
            Method method = this.methods[n];
            Class<?> clazz = method.getDeclaringClass();
            boolean bl = this.generateAgent ? clazz != (class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object) && clazz != (class$com$globalinfotek$coabsgrid$ServiceRep == null ? Generator.class$("com.globalinfotek.coabsgrid.ServiceRep") : class$com$globalinfotek$coabsgrid$ServiceRep) && clazz != (class$com$globalinfotek$coabsgrid$AgentRep == null ? Generator.class$("com.globalinfotek.coabsgrid.AgentRep") : class$com$globalinfotek$coabsgrid$AgentRep) : clazz != (class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object) && clazz != (class$com$globalinfotek$coabsgrid$ServiceRep == null ? Generator.class$("com.globalinfotek.coabsgrid.ServiceRep") : class$com$globalinfotek$coabsgrid$ServiceRep);
            if (bl && (!this.inputClassIsWellKnownInterface || this.throwsRemoteException(this.methods[n]))) {
                this.generateMethodHeader(printWriter, method);
                printWriter.println(";");
            }
            ++n;
        }
        printWriter.println("}");
        printWriter.close();
    }

    private void generateMain() throws IOException {
        PrintWriter printWriter;
        String string = this.generateAgent ? this.wellKnownInterfaceName + "Agent" : this.wellKnownInterfaceName + "Service";
        try {
            printWriter = this.openOutputFile(this.packagePath, string + ".java");
        }
        catch (FileExistsException fileExistsException) {
            return;
        }
        printWriter.println("/* Generated " + new Date() + " */");
        if (!this.packageName.equals("")) {
            printWriter.println("package " + this.packageName + ";");
        }
        printWriter.println();
        if (this.inputClassIsInterface && !this.inputClassIsWellKnownInterface && !this.packageName.equals(this.inputClassPackageName)) {
            printWriter.println("import " + this.inputClassPackageName + "." + this.inputClassName + ";");
        }
        if (!this.packageName.equals(this.implementationClassPackageName)) {
            printWriter.println("import " + this.implementationClassPackageName + "." + this.implementationClassName + ";");
        }
        printWriter.println("import java.io.IOException;");
        printWriter.println("import net.jini.core.lookup.ServiceID;");
        printWriter.println("import net.jini.lookup.ServiceIDListener;");
        if (this.generateAgent) {
            printWriter.println("import com.globalinfotek.coabsgrid.AgentRegistrationHelper;");
        } else {
            printWriter.println("import com.globalinfotek.coabsgrid.RegistrationHelper;");
        }
        printWriter.println("import com.globalinfotek.coabsgrid.ShutdownHook;");
        printWriter.println("import com.globalinfotek.coabsgrid.ShutdownHandler;");
        if (this.generateAgent) {
            printWriter.println("import com.globalinfotek.coabsgrid.MessageListener;");
            printWriter.println("import com.globalinfotek.coabsgrid.Message;");
            printWriter.println("import com.globalinfotek.coabsgrid.entry.CoABSAgentDescription;");
        } else {
            printWriter.println("import com.globalinfotek.coabsgrid.entry.CoABSServiceDescription;");
        }
        printWriter.println();
        printWriter.print("public class " + string);
        if (this.generateAgent) {
            printWriter.println(" implements MessageListener");
        }
        printWriter.println(" {");
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("  private AgentRegistrationHelper _reg;");
        } else {
            printWriter.println("  private RegistrationHelper _reg;");
        }
        printWriter.println();
        printWriter.println("  public " + string + "(String args[]) throws IOException,");
        printWriter.println("    ClassNotFoundException {");
        printWriter.println();
        printWriter.println("    // EDIT: edit the following line to correctly instantiate");
        if (this.generateAgent) {
            printWriter.println("    //       the Java class that implements your agent");
        } else {
            printWriter.println("    //       the Java class that implements your service");
        }
        if (this.inputClassIsInterface && !this.inputClassIsWellKnownInterface) {
            printWriter.print("    final " + this.inputClassName);
        } else {
            printWriter.print("    final " + this.implementationClassName);
        }
        if (this.generateAgent) {
            printWriter.println(" agent = new " + this.implementationClassName + "();");
        } else {
            printWriter.println(" service = new " + this.implementationClassName + "();");
        }
        printWriter.println();
        printWriter.println("    // EDIT: remove the following lines of code if there is nothing");
        printWriter.println("    //       that needs to be done to correctly shut down the Java");
        if (this.generateAgent) {
            printWriter.println("    //       class that implements your agent here");
        } else {
            printWriter.println("    //       class that implements your service here");
        }
        printWriter.println("    ShutdownHook hook = new ShutdownHook() {");
        printWriter.println("      public void cleanup() {");
        printWriter.println("        // EDIT: insert any code necessary to correctly shut down the");
        if (this.generateAgent) {
            printWriter.println("        //       Java class that implements your agent here");
        } else {
            printWriter.println("        //       Java class that implements your service here");
        }
        printWriter.println("      }");
        printWriter.println("    };");
        printWriter.println("    ShutdownHandler.addHook(hook);");
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("    " + this.wellKnownInterfaceName + "AgentHelper helper = new " + this.wellKnownInterfaceName + "AgentHelper(agent);");
        } else {
            printWriter.println("    " + this.wellKnownInterfaceName + "ServiceHelper helper = new " + this.wellKnownInterfaceName + "ServiceHelper(service);");
        }
        printWriter.println();
        printWriter.println("    // EDIT: this assumes that args[0] is the name that you want to");
        if (this.generateAgent) {
            printWriter.println("    //       assign to your agent in its CoABSAgentDescription;");
        } else {
            printWriter.println("    //       assign to your agent in its CoABSServiceDescription;");
        }
        printWriter.println("    //       if that is not the case, change the first parameter of");
        printWriter.println("    //       the constructor accordingly");
        if (this.generateAgent) {
            printWriter.println("    " + this.wellKnownInterfaceName + "AgentRep rep = new " + this.wellKnownInterfaceName + "AgentRep(args[0], helper);");
        } else {
            printWriter.println("    " + this.wellKnownInterfaceName + "ServiceRep rep = new " + this.wellKnownInterfaceName + "ServiceRep(args[0], helper);");
        }
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("    _reg = new AgentRegistrationHelper(helper);");
        } else {
            printWriter.println("    _reg = new RegistrationHelper(helper);");
        }
        printWriter.println();
        printWriter.println("    // EDIT: add advertised capabilities here - for example:");
        printWriter.println("    //_reg.addAdvertisedCapability(YOUR_ENTRY_GOES_HERE);");
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("    // EDIT: add details to your CoABSAgentDescription here");
            printWriter.println("    CoABSAgentDescription desc = _reg.getCoABSAgentDescription();");
        } else {
            printWriter.println("    // EDIT: add details to your CoABSServiceDescription here");
            printWriter.println("    CoABSServiceDescription desc = _reg.getCoABSServiceDescription();");
        }
        printWriter.println("    desc.description = \"YOUR DESCRIPTION GOES HERE\";");
        printWriter.println("    desc.organization = \"YOUR ORGANIZATION GOES HERE\";");
        printWriter.println();
        printWriter.println("    // EDIT: this assumes that you want to save the ServiceID in a");
        printWriter.println("    //       file to use in future invocations; if that is not the");
        printWriter.println("    //       case, remove or change the following lines of code");
        printWriter.println("    String filename = \"" + string + "_ServiceIDFile\";");
        printWriter.println("    try {");
        printWriter.println("      _reg.readServiceIDFromFile(filename);");
        printWriter.println("      System.out.println(\"Read ServiceID from file:\");");
        printWriter.println("      System.out.println(\"  ServiceID: \" + _reg.getServiceID());");
        printWriter.println("      System.out.println(\"  File name: \" + filename);");
        printWriter.println("    } catch (IOException e) {");
        printWriter.println("      System.err.println(\"Could not read ServiceID from file: \" +");
        printWriter.println("        filename);");
        printWriter.println("      System.err.println(\"Getting a ServiceID from the lookup service.\");");
        printWriter.println("      addServiceIDListener(filename);");
        printWriter.println("    }");
        if (this.generateAgent) {
            printWriter.println();
            printWriter.println("    _reg.addMessageListener(this);");
        }
        printWriter.println();
        printWriter.println("    _reg.registerAgent();");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  // EDIT: this method is used if you want to save the ServiceID in a");
        printWriter.println("  //       file to use in future invocations; if that is not the case,");
        printWriter.println("  //       you can remove this method");
        printWriter.println("  public void addServiceIDListener(final String filename) {");
        printWriter.println("    _reg.addServiceIDListener(new ServiceIDListener() {");
        printWriter.println("      public void serviceIDNotify(ServiceID id) {");
        printWriter.println("        try {");
        printWriter.println("          _reg.writeServiceIDToFile(filename);");
        printWriter.println("          System.out.println(\"Wrote ServiceID to file:\");");
        printWriter.println("          System.out.println(\"  ServiceID: \" + _reg.getServiceID());");
        printWriter.println("          System.out.println(\"  File name: \" + filename);");
        printWriter.println("        } catch (IOException e) {");
        printWriter.println("          System.err.println(\"I/O exception writing ServiceID to file: \" +");
        printWriter.println("            filename);");
        printWriter.println("          e.printStackTrace();");
        printWriter.println("        } catch (RuntimeException e) {");
        printWriter.println("          System.err.println(\"Exception writing ServiceID to file: \" + ");
        printWriter.println("            filename);");
        printWriter.println("          e.printStackTrace();");
        printWriter.println("        }");
        printWriter.println("        _reg.removeServiceIDListener(this);");
        printWriter.println("      }");
        printWriter.println("    });");
        printWriter.println("  }");
        if (this.generateAgent) {
            printWriter.println();
            printWriter.println("  public synchronized void messageAdded(Message msg) {");
            printWriter.println("  // EDIT: add message handling code here");
            printWriter.println("    System.out.println(\"******* RECEIVED MESSAGE *******\\n\" + msg);");
            printWriter.println("    _reg.removeMessage(msg);");
            printWriter.println("  }");
        }
        printWriter.println();
        printWriter.println("  public static void main(String[] args) throws IOException,");
        printWriter.println("    ClassNotFoundException {");
        printWriter.println();
        printWriter.println("    new " + string + "(args);");
        printWriter.println("  }");
        printWriter.println("}");
        printWriter.close();
    }

    private void generateHelper() throws IOException {
        String string;
        PrintWriter printWriter;
        String string2 = this.generateAgent ? this.wellKnownInterfaceName + "AgentHelper" : this.wellKnownInterfaceName + "ServiceHelper";
        try {
            printWriter = this.openOutputFile(this.packagePath, string2 + ".java");
        }
        catch (FileExistsException fileExistsException) {
            return;
        }
        printWriter.println("/* Generated " + new Date() + " */");
        if (!this.packageName.equals("")) {
            printWriter.println("package " + this.packageName + ";");
        }
        printWriter.println();
        if (this.inputClassIsInterface && !this.inputClassIsWellKnownInterface) {
            if (!this.packageName.equals(this.inputClassPackageName)) {
                printWriter.println("import " + this.inputClassPackageName + "." + this.inputClassName + ";");
            }
            string = this.inputClassName;
        } else {
            if (!this.packageName.equals(this.implementationClassPackageName)) {
                printWriter.println("import " + this.implementationClassPackageName + "." + this.implementationClassName + ";");
            }
            string = this.implementationClassName;
        }
        printWriter.println("import java.rmi.RemoteException;");
        printWriter.println("import java.io.IOException;");
        if (this.generateAgent) {
            printWriter.println("import com.globalinfotek.coabsgrid.GridAgentHelper;");
        } else {
            printWriter.println("import com.globalinfotek.coabsgrid.GridServiceHelper;");
        }
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("public class " + string2 + " extends GridAgentHelper implements " + this.wellKnownInterfaceName + "RemoteInterface {");
        } else {
            printWriter.println("public class " + string2 + " extends GridServiceHelper implements " + this.wellKnownInterfaceName + "RemoteInterface {");
        }
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("  private " + string + " _agent;");
        } else {
            printWriter.println("  private " + string + " _service;");
        }
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("  public " + string2 + "(" + string + " agent) throws IOException {");
            printWriter.println("    _agent = agent;");
        } else {
            printWriter.println("  public " + string2 + "(" + string + " service) throws IOException {");
            printWriter.println("    _service = service;");
        }
        printWriter.println("  }");
        int n = 0;
        while (n < this.methods.length) {
            Method method = this.methods[n];
            Class<?> clazz = method.getDeclaringClass();
            boolean bl = this.generateAgent ? clazz != (class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object) && clazz != (class$com$globalinfotek$coabsgrid$ServiceRep == null ? Generator.class$("com.globalinfotek.coabsgrid.ServiceRep") : class$com$globalinfotek$coabsgrid$ServiceRep) && clazz != (class$com$globalinfotek$coabsgrid$AgentRep == null ? Generator.class$("com.globalinfotek.coabsgrid.AgentRep") : class$com$globalinfotek$coabsgrid$AgentRep) : clazz != (class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object) && clazz != (class$com$globalinfotek$coabsgrid$ServiceRep == null ? Generator.class$("com.globalinfotek.coabsgrid.ServiceRep") : class$com$globalinfotek$coabsgrid$ServiceRep);
            if (bl && (!this.inputClassIsWellKnownInterface || this.throwsRemoteException(method))) {
                printWriter.println();
                this.generateMethodHeader(printWriter, method);
                printWriter.println(" {");
                printWriter.print("    ");
                if (method.getReturnType() != Void.TYPE) {
                    printWriter.print("return ");
                }
                if (this.generateAgent) {
                    printWriter.print("_agent." + method.getName() + "(");
                } else {
                    printWriter.print("_service." + method.getName() + "(");
                }
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length > 0) {
                    printWriter.print("arg0");
                    int n2 = 1;
                    while (n2 < classArray.length) {
                        printWriter.print(", arg" + n2);
                        ++n2;
                    }
                }
                printWriter.println(");");
                printWriter.println("  }");
            }
            ++n;
        }
        printWriter.println("}");
        printWriter.close();
    }

    private void generateRep() throws IOException {
        PrintWriter printWriter;
        String string = this.generateAgent ? this.wellKnownInterfaceName + "AgentRep" : this.wellKnownInterfaceName + "ServiceRep";
        try {
            printWriter = this.openOutputFile(this.packagePath, string + ".java");
        }
        catch (FileExistsException fileExistsException) {
            return;
        }
        printWriter.println("/* Generated " + new Date() + " */");
        if (!this.packageName.equals("")) {
            printWriter.println("package " + this.packageName + ";");
        }
        printWriter.println();
        if (!this.wellKnownInterfacePackageName.equals(this.packageName)) {
            printWriter.println("import " + this.wellKnownInterfacePackageName + "." + this.wellKnownInterfaceName + ";");
        }
        printWriter.println("import java.rmi.RemoteException;");
        printWriter.println("import java.io.IOException;");
        if (this.generateAgent) {
            printWriter.println("import com.globalinfotek.coabsgrid.DefaultAgentRep;");
        } else {
            printWriter.println("import com.globalinfotek.coabsgrid.DefaultServiceRep;");
        }
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("public class " + string + " extends DefaultAgentRep implements " + this.wellKnownInterfaceName + " {");
        } else {
            printWriter.println("public class " + string + " extends DefaultServiceRep implements " + this.wellKnownInterfaceName + " {");
        }
        printWriter.println();
        printWriter.println("  private " + this.wellKnownInterfaceName + "RemoteInterface _remoteInterface;");
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("  public " + string + "(String name, " + this.wellKnownInterfaceName + "AgentHelper helper) throws IOException {");
        } else {
            printWriter.println("  public " + string + "(String name, " + this.wellKnownInterfaceName + "ServiceHelper helper) throws IOException {");
        }
        printWriter.println("    super(name, helper);");
        printWriter.println("    _remoteInterface = helper;");
        printWriter.println("  }");
        int n = 0;
        while (n < this.methods.length) {
            Method method = this.methods[n];
            Class<?> clazz = method.getDeclaringClass();
            boolean bl = this.generateAgent ? clazz != (class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object) && clazz != (class$com$globalinfotek$coabsgrid$ServiceRep == null ? Generator.class$("com.globalinfotek.coabsgrid.ServiceRep") : class$com$globalinfotek$coabsgrid$ServiceRep) && clazz != (class$com$globalinfotek$coabsgrid$AgentRep == null ? Generator.class$("com.globalinfotek.coabsgrid.AgentRep") : class$com$globalinfotek$coabsgrid$AgentRep) : clazz != (class$java$lang$Object == null ? Generator.class$("java.lang.Object") : class$java$lang$Object) && clazz != (class$com$globalinfotek$coabsgrid$ServiceRep == null ? Generator.class$("com.globalinfotek.coabsgrid.ServiceRep") : class$com$globalinfotek$coabsgrid$ServiceRep);
            if (bl && (!this.inputClassIsWellKnownInterface || this.throwsRemoteException(method))) {
                printWriter.println();
                this.generateMethodHeader(printWriter, method);
                printWriter.println(" {");
                printWriter.print("    ");
                if (method.getReturnType() != Void.TYPE) {
                    printWriter.print("return ");
                }
                printWriter.print("_remoteInterface." + method.getName() + "(");
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length > 0) {
                    printWriter.print("arg0");
                    int n2 = 1;
                    while (n2 < classArray.length) {
                        printWriter.print(", arg" + n2);
                        ++n2;
                    }
                }
                printWriter.println(");");
                printWriter.println("  }");
            }
            ++n;
        }
        printWriter.println("}");
        printWriter.close();
    }

    private void generateTestClient() throws IOException {
        PrintWriter printWriter;
        String string = this.wellKnownInterfaceName + "Client";
        try {
            printWriter = this.openOutputFile(this.clientPackagePath, string + ".java");
        }
        catch (FileExistsException fileExistsException) {
            return;
        }
        printWriter.println("/* Generated " + new Date() + " */");
        if (!this.clientPackageName.equals("")) {
            printWriter.println("package " + this.clientPackageName + ";");
        }
        printWriter.println();
        if (!this.wellKnownInterfacePackageName.equals(this.clientPackageName)) {
            printWriter.println("import " + this.wellKnownInterfacePackageName + "." + this.wellKnownInterfaceName + ";");
        }
        printWriter.println("import java.io.IOException;");
        printWriter.println("import com.globalinfotek.coabsgrid.Directory;");
        printWriter.println("import com.globalinfotek.coabsgrid.CoabsgridConfig;");
        if (this.generateAgent) {
            printWriter.println("import com.globalinfotek.coabsgrid.entry.CoABSAgentDescription;");
        } else {
            printWriter.println("import com.globalinfotek.coabsgrid.entry.CoABSServiceDescription;");
        }
        printWriter.println("import net.jini.core.entry.Entry;");
        printWriter.println("import net.jini.core.lookup.ServiceItem;");
        printWriter.println("import net.jini.core.lookup.ServiceTemplate;");
        printWriter.println();
        printWriter.println("public class " + string + " {");
        printWriter.println();
        printWriter.println("  public static void main(String[] args) throws IOException {");
        printWriter.println();
        printWriter.println("    Directory dir = CoabsgridConfig.getSharedDirectory();");
        printWriter.println("    Class[] classArray = { " + this.wellKnownInterfaceName + ".class };");
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("    // EDIT: this assumes that args[0] is the name that you have");
            printWriter.println("    //       assigned to your service in its CoABSAgentDescription");
            printWriter.println("    //       Entry; if that is not the case, change the");
            printWriter.println("    //       CoABSAgentDescription constructor's parameter below");
            printWriter.println("    //       accordingly");
            printWriter.println("    Entry[] entryArray = {new CoABSAgentDescription(args[0])};");
        } else {
            printWriter.println("    // EDIT: this assumes that args[0] is the name that you have");
            printWriter.println("    //       assigned to your service in its CoABSServiceDescription");
            printWriter.println("    //       Entry; if that is not the case, change the");
            printWriter.println("    //       CoABSServiceDescription constructor's parameter below");
            printWriter.println("    //       accordingly");
            printWriter.println("    Entry[] entryArray = {new CoABSServiceDescription(args[0])};");
        }
        printWriter.println();
        printWriter.println("    ServiceTemplate template =");
        printWriter.println("      new ServiceTemplate(null, classArray, entryArray);");
        printWriter.println("    ServiceItem[] items = dir.lookup(template);");
        printWriter.println("    if (items.length < 1) {");
        if (this.generateAgent) {
            printWriter.println("      System.err.println(\"Could not find agent.\");");
        } else {
            printWriter.println("      System.err.println(\"Could not find service.\");");
        }
        printWriter.println("      System.exit(-1);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    // EDIT: place your client code here");
        printWriter.println();
        printWriter.println("  }");
        printWriter.println("}");
        printWriter.close();
    }

    private void generateAntScript() throws IOException {
        int n;
        String string;
        int n2;
        String string2;
        String string3;
        String string4 = this.generateAgent ? "build-agent" : "build-service";
        String string5 = string3 = System.getProperty("user.dir");
        StringBuffer stringBuffer = new StringBuffer(string5);
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            if (stringBuffer.charAt(n3) == File.separatorChar) {
                stringBuffer.setCharAt(n3, '/');
            }
            ++n3;
        }
        string5 = stringBuffer.toString();
        String string6 = string3 + "\\lib\\config\\coabsgrid.props";
        Properties properties = new Properties();
        properties.load(new FileInputStream(string6));
        PrintWriter printWriter = null;
        boolean bl = false;
        try {
            printWriter = this.openOutputFile(this.antPath, string4 + ".props");
        }
        catch (FileExistsException fileExistsException) {
            bl = true;
        }
        if (!bl) {
            if (this.sourcePath == null) {
                string2 = ".";
            } else {
                string2 = this.sourcePath;
                if (File.separatorChar != '/') {
                    stringBuffer = new StringBuffer(string2);
                    n2 = 0;
                    while (n2 < stringBuffer.length()) {
                        if (stringBuffer.charAt(n2) == File.separatorChar) {
                            stringBuffer.setCharAt(n2, '/');
                        }
                        ++n2;
                    }
                    string2 = stringBuffer.toString();
                }
            }
            printWriter.println("<!-- Generated " + new Date() + " -->");
            printWriter.println("coabs.grid=" + string5);
            printWriter.println("class.server.machine=" + properties.getProperty("com.globalinfotek.coabsgrid.class.server.machine"));
            printWriter.println("class.server.port=" + properties.getProperty("com.globalinfotek.coabsgrid.class.server.port"));
            if (this.generateAgent) {
                printWriter.println("class.server.relative.path=" + this.wellKnownInterfaceName + "-Agent");
            } else {
                printWriter.println("class.server.relative.path=" + this.wellKnownInterfaceName + "-Service");
            }
            printWriter.println("codebase.dir=${coabs.grid}/lib/codebase/${class.server.relative.path}");
            printWriter.println("src.dir=" + string2);
            printWriter.println("class.dir=" + this.compiledPath);
            printWriter.println("legacy.class.dir=" + this.classpath);
            printWriter.println("args=\"" + this.commandLineArguments + "\"");
            printWriter.close();
        }
        try {
            printWriter = this.openOutputFile(this.antPath, string4 + ".xml");
        }
        catch (FileExistsException fileExistsException) {
            return;
        }
        if (this.packageName.equals("")) {
            string2 = "";
        } else {
            stringBuffer = new StringBuffer(this.packageName);
            n2 = 0;
            while (n2 < stringBuffer.length()) {
                if (stringBuffer.charAt(n2) == '.') {
                    stringBuffer.setCharAt(n2, '/');
                }
                ++n2;
            }
            stringBuffer.append("/");
            string2 = stringBuffer.toString();
        }
        if (this.wellKnownInterfacePackageName.equals("")) {
            string = "";
        } else {
            stringBuffer = new StringBuffer(this.wellKnownInterfacePackageName);
            n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '.') {
                    stringBuffer.setCharAt(n, '/');
                }
                ++n;
            }
            stringBuffer.append("/");
            string = stringBuffer.toString();
        }
        printWriter.println("<!-- Generated " + new Date() + " -->");
        if (this.generateAgent) {
            printWriter.println("<!-- an Ant file to build and run an agent wrapping a legacy Java class  -->");
        } else {
            printWriter.println("<!-- an Ant file to build and run a service wrapping a legacy Java class  -->");
        }
        printWriter.println("<project default=\"compile\" basedir=\".\">");
        printWriter.println();
        printWriter.println("  <!-- read in property file -->");
        printWriter.println("  <property file=\"" + string4 + ".props\"/>");
        printWriter.println();
        printWriter.println("  <!-- build classpath -->");
        printWriter.println("  <path id=\"project.classpath\">");
        printWriter.println("    <fileset dir=\"${coabs.grid}\">");
        printWriter.println("      <include name=\"lib/jini-core.jar\"/>");
        printWriter.println("      <include name=\"lib/jini-ext.jar\"/>");
        printWriter.println("      <include name=\"lib/sun-util.jar\"/>");
        printWriter.println("      <include name=\"lib/reggie.jar\"/>");
        printWriter.println("    </fileset>");
        printWriter.println("    <fileset dir=\"${coabs.grid}/lib/classpath\">");
        printWriter.println("      <include name=\"uiapi100.zip\"/>");
        printWriter.println("    </fileset>");
        printWriter.println("    <fileset dir=\"${coabs.grid}/lib\">");
        printWriter.println("      <include name=\"grid.jar\"/>");
        printWriter.println("    </fileset>");
        printWriter.println("    <pathelement path=\"${coabs.grid}/lib\"/>");
        printWriter.println("    <pathelement path=\"${coabs.grid}/lib/classpath\"/>");
        printWriter.println("    <pathelement path=\"${legacy.class.dir}\"/>");
        printWriter.println("    <pathelement path=\"${class.dir}\"/>");
        printWriter.println("  </path>");
        printWriter.println();
        printWriter.println("  <!-- default target - compile -->");
        printWriter.println("  <target name=\"compile\">");
        printWriter.println("    <mkdir dir=\"${class.dir}\"/>");
        printWriter.println("    <javac");
        printWriter.println("      srcdir=\"${src.dir}\"");
        printWriter.println("      destdir=\"${class.dir}\"");
        printWriter.println("      deprecation=\"on\"");
        printWriter.println("      classpathref=\"project.classpath\"");
        printWriter.println("    />");
        printWriter.println("    <rmic");
        printWriter.println("      base=\"${class.dir}\"");
        printWriter.println("      verify=\"true\"");
        if (this.generateAgent) {
            printWriter.println("      includes=\"" + string2 + this.wellKnownInterfaceName + "AgentHelper.class\"");
        } else {
            printWriter.println("      includes=\"" + string2 + this.wellKnownInterfaceName + "ServiceHelper.class\"");
        }
        printWriter.println("      stubversion=\"1.2\"");
        printWriter.println("      classpathref=\"project.classpath\"");
        printWriter.println("    />");
        printWriter.println("    <copy todir=\"${codebase.dir}\">");
        printWriter.println("      <fileset dir=\"${class.dir}\">");
        printWriter.println("        <include name=\"" + string + this.wellKnownInterfaceName + ".class\"/>");
        printWriter.println("        <include name=\"" + string2 + this.wellKnownInterfaceName + "RemoteInterface.class\"/>");
        if (this.generateAgent) {
            printWriter.println("        <include name=\"" + string2 + this.wellKnownInterfaceName + "AgentHelper.class\"/>");
            printWriter.println("        <include name=\"" + string2 + this.wellKnownInterfaceName + "AgentHelper_Stub.class\"/>");
            printWriter.println("        <include name=\"" + string2 + this.wellKnownInterfaceName + "AgentRep.class\"/>");
        } else {
            printWriter.println("        <include name=\"" + string2 + this.wellKnownInterfaceName + "ServiceHelper.class\"/>");
            printWriter.println("        <include name=\"" + string2 + this.wellKnownInterfaceName + "ServiceHelper_Stub.class\"/>");
            printWriter.println("        <include name=\"" + string2 + this.wellKnownInterfaceName + "ServiceRep.class\"/>");
        }
        printWriter.println("      </fileset>");
        printWriter.println("    </copy>");
        printWriter.println();
        printWriter.println("    <!-- EDIT: include any legacy classes referred to by the well-known");
        printWriter.println("               interface after this comment; for example,");
        printWriter.println("    <copy todir=\"${codebase.dir}\">");
        printWriter.println("      <fileset dir=\"${legacy.class.dir}\">");
        printWriter.println("        <include name=\"abc/def.class\"/>");
        printWriter.println("      </fileset>");
        printWriter.println("    </copy>");
        printWriter.println("    -->");
        if (this.dependencyClassNames.size() > 0) {
            printWriter.println("    <copy todir=\"${codebase.dir}\">");
            n = 0;
            while (n < this.dependencyClassNames.size()) {
                Vector vector = (Vector)this.dependencyClassNames.elementAt(n);
                printWriter.println("      <fileset dir=\"" + vector.elementAt(0) + "\">");
                int n4 = 1;
                while (n4 < vector.size()) {
                    printWriter.println("        <include name=\"" + vector.elementAt(n4) + "\"/>");
                    ++n4;
                }
                printWriter.println("      </fileset>");
                ++n;
            }
            printWriter.println("    </copy>");
        }
        printWriter.println("  </target>");
        printWriter.println();
        printWriter.println("  <!-- delete all of the files and directories created by this build file -->");
        printWriter.println("  <target name=\"clean\">");
        printWriter.println("    <delete dir=\"${codebase.dir}\"/>");
        printWriter.println("    <delete dir=\"${class.dir}\"/>");
        printWriter.println("  </target>");
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("  <!-- run the agent -->");
        } else {
            printWriter.println("  <!-- run the service -->");
        }
        printWriter.println("  <target name=\"run\">");
        printWriter.println("    <property name=\"http.base\" value=\"http://${class.server.machine}:${class.server.port}//${class.server.relative.path}\"/>");
        printWriter.println("    <java");
        string2 = this.packageName.equals("") ? "" : this.packageName + ".";
        if (this.generateAgent) {
            printWriter.println("      classname=\"" + string2 + this.wellKnownInterfaceName + "Agent\"");
        } else {
            printWriter.println("      classname=\"" + string2 + this.wellKnownInterfaceName + "Service\"");
        }
        printWriter.println("      classpathref=\"project.classpath\"");
        printWriter.println("      fork=\"yes\">");
        String string7 = properties.getProperty("java.rmi.server.codebase");
        printWriter.println("      <jvmarg value=\"-Djava.rmi.server.codebase=" + string7 + " ${http.base}/\"/>");
        printWriter.println("      <jvmarg value=\"-Djava.security.policy=" + properties.getProperty("java.security.policy") + "\"/>");
        printWriter.println("      <arg line=\"${args}\"/>");
        printWriter.println("    </java>");
        printWriter.println("  </target>");
        printWriter.println("</project>");
        printWriter.close();
    }

    private void generateTestClientAntScript() throws IOException {
        int n;
        String string;
        int n2;
        String string2;
        String string3;
        String string4 = this.generateAgent ? "build-agent-client" : "build-service-client";
        String string5 = string3 = System.getProperty("user.dir");
        StringBuffer stringBuffer = new StringBuffer(string5);
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            if (stringBuffer.charAt(n3) == File.separatorChar) {
                stringBuffer.setCharAt(n3, '/');
            }
            ++n3;
        }
        string5 = stringBuffer.toString();
        String string6 = string3 + "\\lib\\config\\coabsgrid.props";
        Properties properties = new Properties();
        properties.load(new FileInputStream(string6));
        PrintWriter printWriter = null;
        boolean bl = false;
        try {
            printWriter = this.openOutputFile(this.clientAntPath, string4 + ".props");
        }
        catch (FileExistsException fileExistsException) {
            bl = true;
        }
        if (!bl) {
            string2 = this.clientSourcePath;
            if (File.separatorChar != '/') {
                stringBuffer = new StringBuffer(string2);
                n2 = 0;
                while (n2 < stringBuffer.length()) {
                    if (stringBuffer.charAt(n2) == File.separatorChar) {
                        stringBuffer.setCharAt(n2, '/');
                    }
                    ++n2;
                }
                string2 = stringBuffer.toString();
            }
            printWriter.println("<!-- Generated " + new Date() + " -->");
            printWriter.println("coabs.grid=" + string5);
            printWriter.println("class.server.machine=" + properties.getProperty("com.globalinfotek.coabsgrid.class.server.machine"));
            printWriter.println("class.server.port=" + properties.getProperty("com.globalinfotek.coabsgrid.class.server.port"));
            if (this.generateAgent) {
                printWriter.println("class.server.relative.path=" + this.wellKnownInterfaceName + "-Agent");
            } else {
                printWriter.println("class.server.relative.path=" + this.wellKnownInterfaceName + "-Service");
            }
            printWriter.println("codebase.dir=${coabs.grid}/lib/codebase/${class.server.relative.path}");
            printWriter.println("src.dir=" + string2);
            printWriter.println("class.dir=" + this.compiledClientPath);
            printWriter.println("legacy.class.dir=" + this.classpath);
            if (this.generateAgent) {
                printWriter.println("agent.class.dir=" + this.compiledPath);
            } else {
                printWriter.println("service.class.dir=" + this.compiledPath);
            }
            printWriter.println("args=\"" + this.clientCommandLineArguments + "\"");
            printWriter.close();
        }
        try {
            printWriter = this.openOutputFile(this.clientAntPath, string4 + ".xml");
        }
        catch (FileExistsException fileExistsException) {
            return;
        }
        if (this.clientPackageName.equals("")) {
            string2 = "";
        } else {
            stringBuffer = new StringBuffer(this.clientPackageName);
            n2 = 0;
            while (n2 < stringBuffer.length()) {
                if (stringBuffer.charAt(n2) == '.') {
                    stringBuffer.setCharAt(n2, '/');
                }
                ++n2;
            }
            stringBuffer.append("/");
            string2 = stringBuffer.toString();
        }
        if (this.wellKnownInterfacePackageName.equals("")) {
            string = "";
        } else {
            stringBuffer = new StringBuffer(this.wellKnownInterfacePackageName);
            n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '.') {
                    stringBuffer.setCharAt(n, '/');
                }
                ++n;
            }
            stringBuffer.append("/");
            string = stringBuffer.toString();
        }
        printWriter.println("<!-- Generated " + new Date() + " -->");
        if (this.generateAgent) {
            printWriter.println("<!-- an Ant build file to build and run a client for an agent  -->");
        } else {
            printWriter.println("<!-- an Ant build file to build and run a client for a service  -->");
        }
        printWriter.println("<project default=\"compile\" basedir=\".\">");
        printWriter.println();
        printWriter.println("  <!-- read in property file -->");
        printWriter.println("  <property file=\"" + string4 + ".props\"/>");
        printWriter.println();
        printWriter.println("  <!-- build classpath -->");
        printWriter.println("  <path id=\"project.classpath\">");
        printWriter.println("    <fileset dir=\"${coabs.grid}\">");
        printWriter.println("      <include name=\"lib/jini-core.jar\"/>");
        printWriter.println("      <include name=\"lib/jini-ext.jar\"/>");
        printWriter.println("      <include name=\"lib/sun-util.jar\"/>");
        printWriter.println("      <include name=\"lib/reggie.jar\"/>");
        printWriter.println("    </fileset>");
        printWriter.println("    <fileset dir=\"${coabs.grid}/lib/classpath\">");
        printWriter.println("      <include name=\"uiapi100.zip\"/>");
        printWriter.println("    </fileset>");
        printWriter.println("    <fileset dir=\"${coabs.grid}/lib\">");
        printWriter.println("      <include name=\"grid.jar\"/>");
        printWriter.println("    </fileset>");
        printWriter.println("    <pathelement path=\"${coabs.grid}/lib\"/>");
        printWriter.println("    <pathelement path=\"${coabs.grid}/lib/classpath\"/>");
        printWriter.println("    <pathelement path=\"${class.dir}\"/>");
        printWriter.println("    <pathelement path=\"${codebase.dir}\"/>");
        printWriter.println("  </path>");
        printWriter.println();
        printWriter.println("  <!-- default target - compile -->");
        printWriter.println("  <target name=\"compile\">");
        printWriter.println("    <copy todir=\"${codebase.dir}\">");
        if (this.generateAgent) {
            printWriter.println("      <fileset dir=\"${agent.class.dir}\">");
        } else {
            printWriter.println("      <fileset dir=\"${service.class.dir}\">");
        }
        printWriter.println("        <include name=\"" + string + this.wellKnownInterfaceName + ".class\"/>");
        printWriter.println("      </fileset>");
        printWriter.println("    </copy>");
        printWriter.println();
        printWriter.println("    <!-- EDIT: include any legacy classes referred to by the well-known");
        printWriter.println("               interface after this comment; for example,");
        printWriter.println("    <copy todir=\"${codebase.dir}\">");
        printWriter.println("      <fileset dir=\"${legacy.class.dir}\">");
        printWriter.println("        <include name=\"abc/def.class\"/>");
        printWriter.println("      </fileset>");
        printWriter.println("    </copy>");
        printWriter.println("    -->");
        if (this.dependencyClassNames.size() > 0) {
            printWriter.println("    <copy todir=\"${codebase.dir}\">");
            n = 0;
            while (n < this.dependencyClassNames.size()) {
                Vector vector = (Vector)this.dependencyClassNames.elementAt(n);
                printWriter.println("      <fileset dir=\"" + vector.elementAt(0) + "\">");
                int n4 = 1;
                while (n4 < vector.size()) {
                    printWriter.println("        <include name=\"" + vector.elementAt(n4) + "\"/>");
                    ++n4;
                }
                printWriter.println("      </fileset>");
                ++n;
            }
            printWriter.println("    </copy>");
        }
        printWriter.println();
        printWriter.println("    <mkdir dir=\"${class.dir}\"/>");
        printWriter.println("    <javac");
        printWriter.println("      srcdir=\"${src.dir}\"");
        printWriter.println("      destdir=\"${class.dir}\"");
        printWriter.println("      deprecation=\"on\"");
        printWriter.println("      classpathref=\"project.classpath\"");
        printWriter.println("    />");
        printWriter.println("  </target>");
        printWriter.println();
        printWriter.println("  <!-- delete all of the files and directories created by this build file -->");
        printWriter.println("  <target name=\"clean\">");
        printWriter.println("    <delete dir=\"${codebase.dir}\"/>");
        printWriter.println("    <delete dir=\"${class.dir}\"/>");
        printWriter.println("  </target>");
        printWriter.println();
        if (this.generateAgent) {
            printWriter.println("  <!-- run the agent client -->");
        } else {
            printWriter.println("  <!-- run the service client -->");
        }
        printWriter.println("  <target name=\"run\">");
        printWriter.println("    <property name=\"http.base\" value=\"http://${class.server.machine}:${class.server.port}//${class.server.relative.path}\"/>");
        printWriter.println("    <java");
        string2 = this.clientPackageName != null ? this.clientPackageName + "." : "";
        printWriter.println("      classname=\"" + string2 + this.wellKnownInterfaceName + "Client\"");
        printWriter.println("      classpathref=\"project.classpath\"");
        printWriter.println("      fork=\"yes\">");
        String string7 = properties.getProperty("java.rmi.server.codebase");
        printWriter.println("      <jvmarg value=\"-Djava.rmi.server.codebase=" + string7 + " ${http.base}/\"/>");
        printWriter.println("      <jvmarg value=\"-Djava.security.policy=" + properties.getProperty("java.security.policy") + "\"/>");
        printWriter.println("      <arg line=\"${args}\"/>");
        printWriter.println("    </java>");
        printWriter.println("  </target>");
        printWriter.println("</project>");
        printWriter.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

