/*
 * Decompiled with CFR 0.152.
 */
package com.globalinfotek.coabsgrid.wrapping;

import com.globalinfotek.coabsgrid.wrapping.GenerateClientAntScripts4WizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorUtils;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardState;
import com.globalinfotek.coabsgrid.wrapping.MultiLineLabelUI;
import com.globalinfotek.coabsgrid.wrapping.WizardPanel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class GenerateClientAntScripts3WizardPanel
extends GeneratorWizardPanel {
    private JPanel mainLabelPanel = new JPanel();
    private JLabel mainLabel = new JLabel();
    private JPanel pathPanel = new JPanel();
    private JLabel pathLabel = new JLabel();
    private JTextField pathTextField = new JTextField();
    private JButton pathBrowseButton = new JButton();
    private WizardPanel nextPanel = null;
    private String initialPath;
    private boolean initiallyFinishable;

    public GenerateClientAntScripts3WizardPanel(GeneratorWizardState generatorWizardState) {
        super(generatorWizardState);
        String string = "The generated test client Ant scripts will compile the generated test client Java source files into\nJava class files.  In which directory would you like the compiled test client Java class files to be\nplaced?\n\nThe directory which you specify will be the root of the directory hierarchy matching the package\nheirarchy of the Java class.  If any of the relevant directories do not exist, they will be created.\n\nIf the directory does not exist, it will be created.  If you enter a relative directory (i.e. one that does\nnot begin with a file system root directory), the directory will be relative to the directory in which the\nAnt script files are placed.";
        this.mainLabel.setText(string);
        this.mainLabel.setForeground(Color.black);
        this.mainLabel.setUI(new MultiLineLabelUI());
        this.mainLabelPanel.add(this.mainLabel);
        this.add(this.mainLabelPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(new JSeparator());
        this.add(Box.createVerticalStrut(10));
        this.pathPanel.setLayout(new FlowLayout(0));
        this.pathLabel.setText("Directory for compiled\ntest client Java\nclass files:");
        this.pathLabel.setLabelFor(this.pathTextField);
        this.pathLabel.setForeground(Color.black);
        this.pathLabel.setUI(new MultiLineLabelUI());
        this.pathPanel.add(this.pathLabel);
        this.pathTextField.setColumns(30);
        this.pathTextField.setText(this.getGeneratorWizardState().getGenerator().getClientSourcePath());
        this.pathTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                GenerateClientAntScripts3WizardPanel.this.pathTextFieldKeyTyped(keyEvent);
            }
        });
        this.pathPanel.add(this.pathTextField);
        this.pathBrowseButton.setForeground(Color.black);
        this.pathBrowseButton.setText("Browse . . .");
        this.pathBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenerateClientAntScripts3WizardPanel.this.browseButtonActionPerformed(actionEvent, GenerateClientAntScripts3WizardPanel.this.pathTextField);
            }
        });
        this.pathPanel.add(this.pathBrowseButton);
        this.add(this.pathPanel);
    }

    private void pathTextFieldKeyTyped(KeyEvent keyEvent) {
        String string = GeneratorUtils.getNewTextFieldText(keyEvent.getKeyChar(), this.pathTextField);
        int n = string.length();
        if (n == 0) {
            this.wizardState.setNextButtonEnabled(false);
            this.wizardState.setFinishButtonEnabled(false);
        } else {
            this.wizardState.setNextButtonEnabled(true);
            if (this.initiallyFinishable) {
                this.wizardState.setFinishButtonEnabled(true);
            }
        }
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent, JTextField jTextField) {
        String string = jTextField.getText();
        if (string.equals("")) {
            string = this.getGeneratorWizardState().getDefaultPath();
        }
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, "Select Directory");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.getGeneratorWizardState().setDefaultPath(file.getParent());
            jTextField.setText(file.getAbsolutePath());
            this.wizardState.setNextButtonEnabled(true);
            this.wizardState.setFinishButtonEnabled(true);
        }
    }

    public WizardPanel getNextPanel() {
        if (this.nextPanel == null || !this.initialPath.equals(this.pathTextField.getText())) {
            this.nextPanel = new GenerateClientAntScripts4WizardPanel(this.getGeneratorWizardState());
            this.wizardState.setFinishButtonEnabled(true);
        }
        return this.nextPanel;
    }

    public void prepareToBeDisplayed() {
        if (this.pathTextField.getText().equals("")) {
            this.wizardState.setNextButtonEnabled(false);
        } else {
            this.wizardState.setNextButtonEnabled(true);
        }
        this.initialPath = this.pathTextField.getText();
        this.initiallyFinishable = this.wizardState.isFinishButtonEnabled();
    }

    public boolean isValid() {
        String string = this.pathTextField.getText();
        if (string.equals("")) {
            return false;
        }
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            this.wizardState.setFinishButtonEnabled(false);
            return false;
        }
        int n = JOptionPane.showConfirmDialog(this, "Directory " + string + " does not exist.\n" + "Do you want to create it?", "DIRECTORY DOES NOT EXIST", 0);
        if (n == 0) {
            try {
                if (file.mkdirs()) {
                    return true;
                }
                JOptionPane.showMessageDialog(this, "Could not create directory " + string + ".", "ERROR", 0);
                this.wizardState.setFinishButtonEnabled(false);
                return false;
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(this, "Could not create directory " + string + ".", "ERROR", 0);
                this.wizardState.setFinishButtonEnabled(false);
                return false;
            }
        }
        this.wizardState.setFinishButtonEnabled(false);
        return false;
    }

    public void showErrors() {
        String string = this.pathTextField.getText();
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                JOptionPane.showMessageDialog(this, string + "is not a directory.", "ERROR", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, string + "does not exist.", "ERROR", 0);
        }
    }

    public void acceptValues() {
        this.getGeneratorWizardState().getGenerator().setCompiledClientPath(this.pathTextField.getText());
    }
}

