/*
 * Decompiled with CFR 0.152.
 */
package com.globalinfotek.coabsgrid.wrapping;

import com.globalinfotek.coabsgrid.wrapping.GenerateClient3WizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorUtils;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardState;
import com.globalinfotek.coabsgrid.wrapping.MultiLineLabelUI;
import com.globalinfotek.coabsgrid.wrapping.WizardPanel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class GenerateClient2WizardPanel
extends GeneratorWizardPanel {
    private JPanel mainLabelPanel = new JPanel();
    private JLabel mainLabel = new JLabel();
    private JPanel namePanel = new JPanel();
    private JLabel nameLabel = new JLabel();
    private JTextField nameTextField = new JTextField();
    private WizardPanel nextPanel = null;
    private String initialPackageName;
    private boolean initiallyFinishable;

    public GenerateClient2WizardPanel(GeneratorWizardState generatorWizardState) {
        super(generatorWizardState);
        String string = "The following Java class will be generated for the test client:\n\n    " + this.getGeneratorWizardState().getGenerator().getWellKnownInterfaceName() + "Client\n" + "\n" + "What package would you like to place this generated Java class in?\n" + "\n" + "If you leave this field empty, the Java default (empty) package will be used.\n";
        this.mainLabel.setText(string);
        this.mainLabel.setForeground(Color.black);
        this.mainLabel.setUI(new MultiLineLabelUI());
        this.mainLabelPanel.add(this.mainLabel);
        this.add(this.mainLabelPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(new JSeparator());
        this.add(Box.createVerticalStrut(10));
        this.namePanel.setLayout(new FlowLayout(0));
        this.nameLabel.setText("Package name for\ngenerated test\nclient Java class:");
        this.nameLabel.setForeground(Color.black);
        this.nameLabel.setUI(new MultiLineLabelUI());
        this.nameLabel.setLabelFor(this.nameTextField);
        this.namePanel.add(this.nameLabel);
        this.nameTextField.setColumns(30);
        this.nameTextField.setText(this.getGeneratorWizardState().getGenerator().getPackageName());
        this.nameTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                GenerateClient2WizardPanel.this.nameTextFieldKeyTyped(keyEvent);
            }
        });
        this.namePanel.add(this.nameTextField);
        this.add(this.namePanel);
    }

    private void nameTextFieldKeyTyped(KeyEvent keyEvent) {
        String string = GeneratorUtils.getNewTextFieldText(keyEvent.getKeyChar(), this.nameTextField);
        int n = string.length();
        if (string.equals(this.initialPackageName)) {
            if (this.initiallyFinishable) {
                this.wizardState.setFinishButtonEnabled(true);
            }
        } else {
            this.wizardState.setFinishButtonEnabled(false);
        }
    }

    public WizardPanel getNextPanel() {
        if (this.nextPanel == null || !this.initialPackageName.equals(this.nameTextField.getText())) {
            String string = this.getGeneratorWizardState().getGenerator().getWellKnownInterfaceName() + "Client";
            String string2 = this.nameTextField.getText();
            if (!string2.equals("")) {
                string = string2 + "." + string;
            }
            this.nextPanel = new GenerateClient3WizardPanel(this.getGeneratorWizardState(), string);
        }
        return this.nextPanel;
    }

    public void prepareToBeDisplayed() {
        this.wizardState.setNextButtonEnabled(true);
        this.initialPackageName = this.nameTextField.getText();
        this.initiallyFinishable = this.wizardState.isFinishButtonEnabled();
    }

    public boolean isValid() {
        return GeneratorUtils.isValidPackageName(this.nameTextField.getText());
    }

    public void showErrors() {
        if (!GeneratorUtils.isValidPackageName(this.nameTextField.getText())) {
            JOptionPane.showMessageDialog(this, this.nameTextField.getText() + " is not a valid Java package name.", "ERROR", 0);
        }
    }

    public void acceptValues() {
        this.getGeneratorWizardState().getGenerator().setClientPackageName(this.nameTextField.getText());
    }
}

