/*
 * Decompiled with CFR 0.152.
 */
package com.globalinfotek.coabsgrid.wrapping;

import com.globalinfotek.coabsgrid.wrapping.GenerateAntScripts3WizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorUtils;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardState;
import com.globalinfotek.coabsgrid.wrapping.MultiLineLabelUI;
import com.globalinfotek.coabsgrid.wrapping.WizardPanel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class GenerateAntScripts2WizardPanel
extends GeneratorWizardPanel {
    private JPanel mainLabelPanel = new JPanel();
    private JLabel mainLabel = new JLabel();
    private JPanel pathPanel = new JPanel();
    private JLabel pathLabel = new JLabel();
    private JTextField pathTextField = new JTextField();
    private JButton pathBrowseButton = new JButton();
    private WizardPanel nextPanel = null;
    private String initialPath;
    private boolean initiallyFinishable;

    public GenerateAntScripts2WizardPanel(GeneratorWizardState generatorWizardState) {
        super(generatorWizardState);
        String string = "The following Ant script files will be generated:\n\n";
        string = this.getGeneratorWizardState().getGenerator().getGenerateAgent() ? string + "    build-agent.xml\n    build-agent.props\n\nYou will be able to compile the agent by typing:\n\n    ant -buildfile build-agent.xml\n\nYou will be able to run the agent by typing:\n\n    ant -buildfile build-agent.xml run\n" : string + "    build-service.xml\n    build-service.props\n\nYou will be able to compile the service by typing:\n\n    ant -buildfile build-service.xml\n\nYou will be able to run the service by typing:\n\n    ant -buildfile build-service.xml run\n";
        string = string + "\nIn which directory would you like to place these generated Ant scripts?\n\nIf the directory does not exist, it will be created.  If you enter a relative directory (i.e. one that does\nnot begin with a file system root directory), the directory will be relative to the directory from which\nthis application was started.";
        this.mainLabel.setText(string);
        this.mainLabel.setForeground(Color.black);
        this.mainLabel.setUI(new MultiLineLabelUI());
        this.mainLabelPanel.add(this.mainLabel);
        this.add(this.mainLabelPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(new JSeparator());
        this.add(Box.createVerticalStrut(10));
        this.pathPanel.setLayout(new FlowLayout(0));
        this.pathLabel.setText("Directory for generated\nAnt scripts:");
        this.pathLabel.setLabelFor(this.pathTextField);
        this.pathLabel.setForeground(Color.black);
        this.pathLabel.setUI(new MultiLineLabelUI());
        this.pathPanel.add(this.pathLabel);
        this.pathTextField.setColumns(30);
        this.pathTextField.setText(this.getGeneratorWizardState().getGenerator().getSourcePath());
        this.pathTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                GenerateAntScripts2WizardPanel.this.pathTextFieldKeyTyped(keyEvent);
            }
        });
        this.pathPanel.add(this.pathTextField);
        this.pathBrowseButton.setForeground(Color.black);
        this.pathBrowseButton.setText("Browse . . .");
        this.pathBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenerateAntScripts2WizardPanel.this.browseButtonActionPerformed(actionEvent, GenerateAntScripts2WizardPanel.this.pathTextField);
            }
        });
        this.pathPanel.add(this.pathBrowseButton);
        this.add(this.pathPanel);
    }

    private void pathTextFieldKeyTyped(KeyEvent keyEvent) {
        String string = GeneratorUtils.getNewTextFieldText(keyEvent.getKeyChar(), this.pathTextField);
        int n = string.length();
        if (n == 0) {
            this.wizardState.setNextButtonEnabled(false);
            this.wizardState.setFinishButtonEnabled(false);
        } else {
            this.wizardState.setNextButtonEnabled(true);
            if (this.initiallyFinishable) {
                this.wizardState.setFinishButtonEnabled(true);
            }
        }
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent, JTextField jTextField) {
        String string = jTextField.getText();
        if (string.equals("")) {
            string = this.getGeneratorWizardState().getDefaultPath();
        }
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, "Select Directory");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.getGeneratorWizardState().setDefaultPath(file.getParent());
            jTextField.setText(file.getAbsolutePath());
            this.wizardState.setNextButtonEnabled(true);
            this.wizardState.setFinishButtonEnabled(true);
        }
    }

    public WizardPanel getNextPanel() {
        if (this.nextPanel == null || !this.initialPath.equals(this.pathTextField.getText())) {
            this.nextPanel = new GenerateAntScripts3WizardPanel(this.getGeneratorWizardState());
        }
        return this.nextPanel;
    }

    public void prepareToBeDisplayed() {
        if (this.pathTextField.getText().equals("")) {
            this.wizardState.setNextButtonEnabled(false);
        } else {
            this.wizardState.setNextButtonEnabled(true);
        }
        this.initialPath = this.pathTextField.getText();
        this.initiallyFinishable = this.wizardState.isFinishButtonEnabled();
    }

    public boolean isValid() {
        String string = this.pathTextField.getText();
        if (string.equals("")) {
            return false;
        }
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            this.wizardState.setFinishButtonEnabled(false);
            return false;
        }
        int n = JOptionPane.showConfirmDialog(this, "Directory " + string + " does not exist.\n" + "Do you want to create it?", "DIRECTORY DOES NOT EXIST", 0);
        if (n == 0) {
            try {
                if (file.mkdirs()) {
                    return true;
                }
                JOptionPane.showMessageDialog(this, "Could not create directory " + string + ".", "ERROR", 0);
                this.wizardState.setFinishButtonEnabled(false);
                return false;
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(this, "Could not create directory " + string + ".", "ERROR", 0);
                this.wizardState.setFinishButtonEnabled(false);
                return false;
            }
        }
        this.wizardState.setFinishButtonEnabled(false);
        return false;
    }

    public void showErrors() {
        String string = this.pathTextField.getText();
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                JOptionPane.showMessageDialog(this, string + "is not a directory.", "ERROR", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, string + "does not exist.", "ERROR", 0);
        }
    }

    public void acceptValues() {
        this.getGeneratorWizardState().getGenerator().setAntPath(this.pathTextField.getText());
    }
}

