/*
 * Decompiled with CFR 0.152.
 */
package com.globalinfotek.coabsgrid.wrapping;

import com.globalinfotek.coabsgrid.wrapping.ClassNameWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorUtils;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardState;
import com.globalinfotek.coabsgrid.wrapping.MultiLineLabelUI;
import com.globalinfotek.coabsgrid.wrapping.WizardPanel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class ClasspathWizardPanel
extends GeneratorWizardPanel {
    private JPanel mainLabelPanel = new JPanel();
    private JLabel mainLabel = new JLabel();
    private JPanel classpathPanel = new JPanel();
    private JLabel classpathLabel = new JLabel();
    private JTextField classpathTextField = new JTextField();
    private JPanel classpathButtonPanel = new JPanel();
    private JButton classpathSystemButton = new JButton();
    private JButton classpathAddDirButton = new JButton();
    private JButton classpathAddJarButton = new JButton();
    private JButton classpathClearButton = new JButton();
    private WizardPanel nextPanel = null;
    private String initialClasspath;
    private boolean initiallyFinishable;

    public ClasspathWizardPanel(GeneratorWizardState generatorWizardState) {
        super(generatorWizardState);
        this.mainLabelPanel.setLayout(new FlowLayout(1));
        String string = "Welcome to the CoABS Grid Code AutoGenerator!\n\nThis tool will take an existing compiled Java class or interface and will generate code necessary to\nmake it available on the CoABS Grid as a Grid service or a Grid agent.\n\nPlease enter the classpath.  This should include the path containing the compiled class file that you\nwish to start from as well as the path to any classes that it depends upon.  If you leave the classpath\nblank, the classpath that this application was started with (the system classpath) will be used.";
        this.mainLabel.setText(string);
        this.mainLabel.setForeground(Color.black);
        this.mainLabel.setUI(new MultiLineLabelUI());
        this.mainLabelPanel.add(this.mainLabel);
        this.add(this.mainLabelPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(new JSeparator());
        this.add(Box.createVerticalStrut(10));
        this.classpathPanel.setLayout(new FlowLayout(0));
        this.classpathLabel.setText("Classpath:");
        this.classpathLabel.setForeground(Color.black);
        this.classpathLabel.setLabelFor(this.classpathTextField);
        this.classpathPanel.add(this.classpathLabel);
        this.classpathTextField.setColumns(40);
        this.classpathTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                ClasspathWizardPanel.this.classpathTextFieldKeyTyped(keyEvent);
            }
        });
        this.classpathPanel.add(this.classpathTextField);
        this.add(this.classpathPanel);
        this.classpathButtonPanel.setLayout(new FlowLayout(2));
        this.classpathSystemButton.setMnemonic('S');
        this.classpathSystemButton.setText("Add System Classpath");
        this.classpathSystemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathWizardPanel.this.addSystemClasspath();
            }
        });
        this.classpathButtonPanel.add(this.classpathSystemButton);
        this.classpathAddDirButton.setMnemonic('D');
        this.classpathAddDirButton.setText("Add Directory . . .");
        this.classpathAddDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathWizardPanel.this.addDirectory();
            }
        });
        this.classpathButtonPanel.add(this.classpathAddDirButton);
        this.classpathAddJarButton.setMnemonic('J');
        this.classpathAddJarButton.setText("Add Jar/Zip File . . .");
        this.classpathAddJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathWizardPanel.this.addJarFile();
            }
        });
        this.classpathButtonPanel.add(this.classpathAddJarButton);
        this.classpathClearButton.setMnemonic('l');
        this.classpathClearButton.setText("Clear");
        this.classpathClearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathWizardPanel.this.clear();
            }
        });
        this.classpathButtonPanel.add(this.classpathClearButton);
        this.add(this.classpathButtonPanel);
    }

    private void addSystemClasspath() {
        String string = this.classpathTextField.getText();
        if (string.equals("")) {
            this.classpathTextField.setText(System.getProperty("java.class.path", ""));
        } else {
            this.classpathTextField.setText(string + File.pathSeparatorChar + System.getProperty("java.class.path", ""));
        }
    }

    private void addDirectory() {
        JFileChooser jFileChooser = new JFileChooser(this.getGeneratorWizardState().getDefaultPath());
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, "Select Directory");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.getGeneratorWizardState().setDefaultPath(file.getParent());
            String string = this.classpathTextField.getText();
            if (string.equals("")) {
                this.classpathTextField.setText(file.getAbsolutePath());
            } else {
                this.classpathTextField.setText(string + File.pathSeparatorChar + file.getAbsolutePath());
            }
        }
    }

    private void addJarFile() {
        JFileChooser jFileChooser = new JFileChooser(this.getGeneratorWizardState().getDefaultPath());
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showDialog(this, "Select File");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.getGeneratorWizardState().setDefaultPath(file.getParent());
            String string = this.classpathTextField.getText();
            if (string.equals("")) {
                this.classpathTextField.setText(file.getAbsolutePath());
            } else {
                this.classpathTextField.setText(string + File.pathSeparatorChar + file.getAbsolutePath());
            }
        }
    }

    private void clear() {
        this.classpathTextField.setText("");
        if (this.initialClasspath.equals("")) {
            if (this.initiallyFinishable) {
                this.wizardState.setFinishButtonEnabled(true);
            }
        } else {
            this.wizardState.setFinishButtonEnabled(false);
        }
    }

    private void classpathTextFieldKeyTyped(KeyEvent keyEvent) {
        String string = GeneratorUtils.getNewTextFieldText(keyEvent.getKeyChar(), this.classpathTextField);
        int n = string.length();
        if (this.initialClasspath.equals(string)) {
            if (this.initiallyFinishable) {
                this.wizardState.setFinishButtonEnabled(true);
            }
        } else {
            this.wizardState.setFinishButtonEnabled(false);
        }
    }

    public WizardPanel getNextPanel() {
        if (this.nextPanel == null || !this.initialClasspath.equals(this.classpathTextField.getText())) {
            this.nextPanel = new ClassNameWizardPanel(this.getGeneratorWizardState(), this.classpathTextField.getText());
        }
        return this.nextPanel;
    }

    public void prepareToBeDisplayed() {
        this.wizardState.setNextButtonEnabled(true);
        this.initialClasspath = this.classpathTextField.getText();
        this.initiallyFinishable = this.wizardState.isFinishButtonEnabled();
    }

    public boolean isValid() {
        return true;
    }

    public void showErrors() {
    }

    public void acceptValues() {
    }
}

