/*
 * Decompiled with CFR 0.152.
 */
package com.globalinfotek.coabsgrid.wrapping;

import com.globalinfotek.coabsgrid.wrapping.GeneratorUtils;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.GeneratorWizardState;
import com.globalinfotek.coabsgrid.wrapping.ImplementationClassNameWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.MethodTable;
import com.globalinfotek.coabsgrid.wrapping.MethodTableModel;
import com.globalinfotek.coabsgrid.wrapping.MultiLineLabelUI;
import com.globalinfotek.coabsgrid.wrapping.WellKnownInterfaceNameWizardPanel;
import com.globalinfotek.coabsgrid.wrapping.WizardPanel;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ClassNameWizardPanel
extends GeneratorWizardPanel {
    private String classpath;
    private JPanel mainLabelPanel;
    private JLabel mainLabel;
    private JPanel namePanel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel nameTypeLabel;
    private JPanel methodPanel;
    private JLabel methodLabel;
    private JScrollPane methodScrollPane;
    private MethodTableModel methodTableModel;
    private MethodTable methodTable;
    private Class inputClass = null;
    private boolean inputClassIsInterface;
    private boolean inputClassIsWellKnownInterface;
    private boolean generateAgent;
    private WizardPanel nextPanel = null;
    private String initialInputClassName;
    private boolean[] initialExcludes;
    private boolean initiallyFinishable;
    static /* synthetic */ Class class$com$globalinfotek$coabsgrid$AgentRep;
    static /* synthetic */ Class class$com$globalinfotek$coabsgrid$ServiceRep;
    static /* synthetic */ Class class$java$lang$Object;

    public ClassNameWizardPanel(GeneratorWizardState generatorWizardState, String string) {
        super(generatorWizardState);
        this.classpath = string == null || string.equals("") ? System.getProperty("java.class.path") : string;
        this.mainLabelPanel = new JPanel();
        this.mainLabel = new JLabel();
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.nameTypeLabel = new JLabel();
        this.methodPanel = new JPanel();
        this.methodLabel = new JLabel();
        this.methodScrollPane = new JScrollPane();
        this.methodTableModel = new MethodTableModel(new Vector());
        this.methodTable = new MethodTable(this.methodTableModel);
        String string2 = "Now you must provide the name of the compiled class or interface that you wish to start from, using its fully\nspecified package name in dotted notation (e.g. com.acme.product.Widget).  Include the package name and\nthe class name, but do not include the file name extension \".class\" at the end of the name.\n\nOnce you have provided the name of a valid class or interface that is in the classpath that you specified, its\npublic instance methods will be displayed.  Methods that are inherited from the AgentRep and ServiceRep\ninterfaces are suppressed.  You can then choose to exclude individual methods from the generated code.";
        this.mainLabel.setText(string2);
        this.mainLabel.setForeground(Color.black);
        this.mainLabel.setUI(new MultiLineLabelUI());
        this.mainLabelPanel.add(this.mainLabel);
        this.add(this.mainLabelPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(new JSeparator());
        this.add(Box.createVerticalStrut(10));
        this.namePanel.setLayout(new FlowLayout(0));
        this.nameLabel.setText("Name of input class or interface:");
        this.nameLabel.setForeground(Color.black);
        this.nameLabel.setLabelFor(this.nameTextField);
        this.namePanel.add(this.nameLabel);
        this.nameTextField.setColumns(30);
        this.nameTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                ClassNameWizardPanel.this.nameTextFieldKeyTyped(keyEvent);
            }
        });
        this.namePanel.add(this.nameTextField);
        this.nameTypeLabel.setText("Interface");
        this.nameTypeLabel.setForeground(Color.red);
        this.nameTypeLabel.setVisible(false);
        this.namePanel.add(this.nameTypeLabel);
        this.add(this.namePanel);
        this.methodPanel.setLayout(new FlowLayout(0));
        this.methodLabel.setText("Methods:");
        this.methodLabel.setForeground(Color.black);
        this.methodLabel.setHorizontalAlignment(2);
        this.methodPanel.add(this.methodLabel);
        this.methodScrollPane.setVerticalScrollBarPolicy(22);
        this.methodScrollPane.setViewportView(this.methodTable);
        this.methodPanel.add(this.methodScrollPane);
        this.add(this.methodPanel);
    }

    private void invalidClassName() {
        this.inputClass = null;
        this.nameTypeLabel.setVisible(false);
        this.methodTableModel = new MethodTableModel(new Vector());
        this.methodTable.setModel(this.methodTableModel);
        this.wizardState.setNextButtonEnabled(false);
        this.wizardState.setFinishButtonEnabled(false);
        this.wizardState.pack();
    }

    private void validateClassName(String string) {
        try {
            this.inputClass = GeneratorUtils.getClass(this.classpath, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.invalidClassName();
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.invalidClassName();
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.invalidClassName();
            return;
        }
        if (!Modifier.isPublic(this.inputClass.getModifiers())) {
            this.invalidClassName();
            return;
        }
        if (this.inputClass.isInterface()) {
            this.inputClassIsInterface = true;
            if ((class$com$globalinfotek$coabsgrid$AgentRep == null ? (class$com$globalinfotek$coabsgrid$AgentRep = ClassNameWizardPanel.class$("com.globalinfotek.coabsgrid.AgentRep")) : class$com$globalinfotek$coabsgrid$AgentRep).isAssignableFrom(this.inputClass)) {
                this.inputClassIsWellKnownInterface = true;
                this.generateAgent = true;
                this.nameTypeLabel.setText("(Agent Interface)");
            } else if ((class$com$globalinfotek$coabsgrid$ServiceRep == null ? (class$com$globalinfotek$coabsgrid$ServiceRep = ClassNameWizardPanel.class$("com.globalinfotek.coabsgrid.ServiceRep")) : class$com$globalinfotek$coabsgrid$ServiceRep).isAssignableFrom(this.inputClass)) {
                this.inputClassIsWellKnownInterface = true;
                this.generateAgent = false;
                this.nameTypeLabel.setText("(Service Interface)");
            } else {
                this.inputClassIsWellKnownInterface = false;
                this.nameTypeLabel.setText("(Interface)");
            }
        } else {
            this.inputClassIsInterface = false;
            this.nameTypeLabel.setText("(Class)");
        }
        try {
            Object object;
            Method[] methodArray = this.inputClass.getMethods();
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < methodArray.length) {
                Class<?> clazz;
                object = methodArray[n];
                if (!Modifier.isStatic(((Method)object).getModifiers()) && (clazz = ((Method)object).getDeclaringClass()) != (class$java$lang$Object == null ? ClassNameWizardPanel.class$("java.lang.Object") : class$java$lang$Object) && clazz != (class$com$globalinfotek$coabsgrid$ServiceRep == null ? ClassNameWizardPanel.class$("com.globalinfotek.coabsgrid.ServiceRep") : class$com$globalinfotek$coabsgrid$ServiceRep) && clazz != (class$com$globalinfotek$coabsgrid$AgentRep == null ? ClassNameWizardPanel.class$("com.globalinfotek.coabsgrid.AgentRep") : class$com$globalinfotek$coabsgrid$AgentRep)) {
                    vector.addElement(object);
                }
                ++n;
            }
            this.nameTypeLabel.setVisible(true);
            this.methodTableModel = new MethodTableModel(vector);
            object = this.nameTextField;
            this.methodTableModel.addTableModelListener(new TableModelListener((JTextField)object){
                private final /* synthetic */ JTextField val$finalNameTextField;
                {
                    this.val$finalNameTextField = jTextField;
                }

                public void tableChanged(TableModelEvent tableModelEvent) {
                    ClassNameWizardPanel.this.updateFinishButton(this.val$finalNameTextField.getText());
                }
            });
            this.methodTable.setModel(this.methodTableModel);
            this.wizardState.setNextButtonEnabled(true);
            this.wizardState.pack();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            final String string2 = GeneratorUtils.unmangleClassName(noClassDefFoundError.getMessage());
            final String string3 = string;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(ClassNameWizardPanel.this, "Could not load class " + string2 + "\n" + "upon which class " + string3 + "\n" + "depends.  Please check classpath and try again.", "ERROR", 0);
                }
            });
            this.invalidClassName();
        }
        this.updateFinishButton(string);
    }

    private void updateFinishButton(String string) {
        if (this.initialInputClassName.equals(string) && Arrays.equals(this.initialExcludes, this.methodTableModel.getExcludes())) {
            if (this.initiallyFinishable) {
                this.wizardState.setFinishButtonEnabled(true);
            }
        } else {
            this.wizardState.setFinishButtonEnabled(false);
        }
    }

    private void nameTextFieldKeyTyped(KeyEvent keyEvent) {
        String string = GeneratorUtils.getNewTextFieldText(keyEvent.getKeyChar(), this.nameTextField);
        int n = string.length();
        if (n == 0) {
            this.invalidClassName();
        } else {
            this.validateClassName(string);
        }
    }

    public WizardPanel getNextPanel() {
        if (this.nextPanel == null || !this.initialInputClassName.equals(this.nameTextField.getText()) || !Arrays.equals(this.initialExcludes, this.methodTableModel.getExcludes())) {
            this.nextPanel = this.inputClassIsInterface ? new ImplementationClassNameWizardPanel(this.getGeneratorWizardState(), this.classpath, this.inputClassIsWellKnownInterface, this.generateAgent, this.inputClass.getName(), this.methodTableModel.getIncludedMethods()) : new WellKnownInterfaceNameWizardPanel(this.getGeneratorWizardState(), this.classpath, false, this.inputClass.getName(), this.inputClass.getName(), this.methodTableModel.getIncludedMethods());
        }
        return this.nextPanel;
    }

    public void prepareToBeDisplayed() {
        if (this.inputClass == null) {
            this.wizardState.setNextButtonEnabled(false);
        } else {
            this.wizardState.setNextButtonEnabled(true);
        }
        this.initialInputClassName = this.nameTextField.getText();
        this.initialExcludes = (boolean[])this.methodTableModel.getExcludes().clone();
        this.initiallyFinishable = this.wizardState.isFinishButtonEnabled();
    }

    public boolean isValid() {
        return true;
    }

    public void showErrors() {
    }

    public void acceptValues() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

